/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.Deployment;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.ServiceEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class Service
implements Serializable,
Cloneable {
    private String serviceArn;
    private String serviceName;
    private String clusterArn;
    private ListWithAutoConstructFlag<LoadBalancer> loadBalancers;
    private String status;
    private Integer desiredCount;
    private Integer runningCount;
    private Integer pendingCount;
    private String taskDefinition;
    private ListWithAutoConstructFlag<Deployment> deployments;
    private String roleArn;
    private ListWithAutoConstructFlag<ServiceEvent> events;

    public String getServiceArn() {
        return this.serviceArn;
    }

    public void setServiceArn(String serviceArn) {
        this.serviceArn = serviceArn;
    }

    public Service withServiceArn(String serviceArn) {
        this.serviceArn = serviceArn;
        return this;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public Service withServiceName(String serviceName) {
        this.serviceName = serviceName;
        return this;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public Service withClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new ListWithAutoConstructFlag();
            this.loadBalancers.setAutoConstruct(true);
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
        loadBalancersCopy.addAll(loadBalancers);
        this.loadBalancers = loadBalancersCopy;
    }

    public Service withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.getLoadBalancers() == null) {
            this.setLoadBalancers(new ArrayList<LoadBalancer>(loadBalancers.length));
        }
        for (LoadBalancer value : loadBalancers) {
            this.getLoadBalancers().add(value);
        }
        return this;
    }

    public Service withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
        } else {
            ListWithAutoConstructFlag loadBalancersCopy = new ListWithAutoConstructFlag(loadBalancers.size());
            loadBalancersCopy.addAll(loadBalancers);
            this.loadBalancers = loadBalancersCopy;
        }
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Service withStatus(String status) {
        this.status = status;
        return this;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public void setDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
    }

    public Service withDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
        return this;
    }

    public Integer getRunningCount() {
        return this.runningCount;
    }

    public void setRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
    }

    public Service withRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
        return this;
    }

    public Integer getPendingCount() {
        return this.pendingCount;
    }

    public void setPendingCount(Integer pendingCount) {
        this.pendingCount = pendingCount;
    }

    public Service withPendingCount(Integer pendingCount) {
        this.pendingCount = pendingCount;
        return this;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public Service withTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
        return this;
    }

    public List<Deployment> getDeployments() {
        if (this.deployments == null) {
            this.deployments = new ListWithAutoConstructFlag();
            this.deployments.setAutoConstruct(true);
        }
        return this.deployments;
    }

    public void setDeployments(Collection<Deployment> deployments) {
        if (deployments == null) {
            this.deployments = null;
            return;
        }
        ListWithAutoConstructFlag deploymentsCopy = new ListWithAutoConstructFlag(deployments.size());
        deploymentsCopy.addAll(deployments);
        this.deployments = deploymentsCopy;
    }

    public Service withDeployments(Deployment ... deployments) {
        if (this.getDeployments() == null) {
            this.setDeployments(new ArrayList<Deployment>(deployments.length));
        }
        for (Deployment value : deployments) {
            this.getDeployments().add(value);
        }
        return this;
    }

    public Service withDeployments(Collection<Deployment> deployments) {
        if (deployments == null) {
            this.deployments = null;
        } else {
            ListWithAutoConstructFlag deploymentsCopy = new ListWithAutoConstructFlag(deployments.size());
            deploymentsCopy.addAll(deployments);
            this.deployments = deploymentsCopy;
        }
        return this;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public Service withRoleArn(String roleArn) {
        this.roleArn = roleArn;
        return this;
    }

    public List<ServiceEvent> getEvents() {
        if (this.events == null) {
            this.events = new ListWithAutoConstructFlag();
            this.events.setAutoConstruct(true);
        }
        return this.events;
    }

    public void setEvents(Collection<ServiceEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
        eventsCopy.addAll(events);
        this.events = eventsCopy;
    }

    public Service withEvents(ServiceEvent ... events) {
        if (this.getEvents() == null) {
            this.setEvents(new ArrayList<ServiceEvent>(events.length));
        }
        for (ServiceEvent value : events) {
            this.getEvents().add(value);
        }
        return this;
    }

    public Service withEvents(Collection<ServiceEvent> events) {
        if (events == null) {
            this.events = null;
        } else {
            ListWithAutoConstructFlag eventsCopy = new ListWithAutoConstructFlag(events.size());
            eventsCopy.addAll(events);
            this.events = eventsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceArn() != null) {
            sb.append("ServiceArn: " + this.getServiceArn() + ",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: " + this.getServiceName() + ",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: " + this.getClusterArn() + ",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: " + this.getLoadBalancers() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getDesiredCount() != null) {
            sb.append("DesiredCount: " + this.getDesiredCount() + ",");
        }
        if (this.getRunningCount() != null) {
            sb.append("RunningCount: " + this.getRunningCount() + ",");
        }
        if (this.getPendingCount() != null) {
            sb.append("PendingCount: " + this.getPendingCount() + ",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: " + this.getTaskDefinition() + ",");
        }
        if (this.getDeployments() != null) {
            sb.append("Deployments: " + this.getDeployments() + ",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: " + this.getRoleArn() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceArn() == null ? 0 : this.getServiceArn().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCount() == null ? 0 : this.getDesiredCount().hashCode());
        hashCode = 31 * hashCode + (this.getRunningCount() == null ? 0 : this.getRunningCount().hashCode());
        hashCode = 31 * hashCode + (this.getPendingCount() == null ? 0 : this.getPendingCount().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getDeployments() == null ? 0 : this.getDeployments().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.getServiceArn() == null ^ this.getServiceArn() == null) {
            return false;
        }
        if (other.getServiceArn() != null && !other.getServiceArn().equals(this.getServiceArn())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDesiredCount() == null ^ this.getDesiredCount() == null) {
            return false;
        }
        if (other.getDesiredCount() != null && !other.getDesiredCount().equals(this.getDesiredCount())) {
            return false;
        }
        if (other.getRunningCount() == null ^ this.getRunningCount() == null) {
            return false;
        }
        if (other.getRunningCount() != null && !other.getRunningCount().equals(this.getRunningCount())) {
            return false;
        }
        if (other.getPendingCount() == null ^ this.getPendingCount() == null) {
            return false;
        }
        if (other.getPendingCount() != null && !other.getPendingCount().equals(this.getPendingCount())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getDeployments() == null ^ this.getDeployments() == null) {
            return false;
        }
        if (other.getDeployments() != null && !other.getDeployments().equals(this.getDeployments())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        return other.getEvents() == null || other.getEvents().equals(this.getEvents());
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

