/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class TaskDefinition
implements Serializable {
    private String taskDefinitionArn;
    private ListWithAutoConstructFlag<ContainerDefinition> containerDefinitions;
    private String family;
    private Integer revision;

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public TaskDefinition withTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new ListWithAutoConstructFlag();
            this.containerDefinitions.setAutoConstruct(true);
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
        containerDefinitionsCopy.addAll(containerDefinitions);
        this.containerDefinitions = containerDefinitionsCopy;
    }

    public TaskDefinition withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.getContainerDefinitions() == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition value : containerDefinitions) {
            this.getContainerDefinitions().add(value);
        }
        return this;
    }

    public TaskDefinition withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
        } else {
            ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
            containerDefinitionsCopy.addAll(containerDefinitions);
            this.containerDefinitions = containerDefinitionsCopy;
        }
        return this;
    }

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public TaskDefinition withFamily(String family) {
        this.family = family;
        return this;
    }

    public Integer getRevision() {
        return this.revision;
    }

    public void setRevision(Integer revision) {
        this.revision = revision;
    }

    public TaskDefinition withRevision(Integer revision) {
        this.revision = revision;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: " + this.getTaskDefinitionArn() + ",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: " + this.getContainerDefinitions() + ",");
        }
        if (this.getFamily() != null) {
            sb.append("Family: " + this.getFamily() + ",");
        }
        if (this.getRevision() != null) {
            sb.append("Revision: " + this.getRevision());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getRevision() == null ? 0 : this.getRevision().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskDefinition)) {
            return false;
        }
        TaskDefinition other = (TaskDefinition)obj;
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getRevision() == null ^ this.getRevision() == null) {
            return false;
        }
        return other.getRevision() == null || other.getRevision().equals(this.getRevision());
    }
}

