/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.NetworkConfiguration;
import com.amazonaws.services.ecs.model.PropagateTags;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.model.TaskVolumeConfiguration;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class StartTaskRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String cluster;
    private SdkInternalList<String> containerInstances;
    private Boolean enableECSManagedTags;
    private Boolean enableExecuteCommand;
    private String group;
    private NetworkConfiguration networkConfiguration;
    private TaskOverride overrides;
    private String propagateTags;
    private String referenceId;
    private String startedBy;
    private SdkInternalList<Tag> tags;
    private String taskDefinition;
    private SdkInternalList<TaskVolumeConfiguration> volumeConfigurations;

    public void setCluster(String cluster) {
        this.cluster = cluster;
    }

    public String getCluster() {
        return this.cluster;
    }

    public StartTaskRequest withCluster(String cluster) {
        this.setCluster(cluster);
        return this;
    }

    public List<String> getContainerInstances() {
        if (this.containerInstances == null) {
            this.containerInstances = new SdkInternalList();
        }
        return this.containerInstances;
    }

    public void setContainerInstances(Collection<String> containerInstances) {
        if (containerInstances == null) {
            this.containerInstances = null;
            return;
        }
        this.containerInstances = new SdkInternalList(containerInstances);
    }

    public StartTaskRequest withContainerInstances(String ... containerInstances) {
        if (this.containerInstances == null) {
            this.setContainerInstances((Collection<String>)new SdkInternalList(containerInstances.length));
        }
        for (String ele : containerInstances) {
            this.containerInstances.add((Object)ele);
        }
        return this;
    }

    public StartTaskRequest withContainerInstances(Collection<String> containerInstances) {
        this.setContainerInstances(containerInstances);
        return this;
    }

    public void setEnableECSManagedTags(Boolean enableECSManagedTags) {
        this.enableECSManagedTags = enableECSManagedTags;
    }

    public Boolean getEnableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public StartTaskRequest withEnableECSManagedTags(Boolean enableECSManagedTags) {
        this.setEnableECSManagedTags(enableECSManagedTags);
        return this;
    }

    public Boolean isEnableECSManagedTags() {
        return this.enableECSManagedTags;
    }

    public void setEnableExecuteCommand(Boolean enableExecuteCommand) {
        this.enableExecuteCommand = enableExecuteCommand;
    }

    public Boolean getEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public StartTaskRequest withEnableExecuteCommand(Boolean enableExecuteCommand) {
        this.setEnableExecuteCommand(enableExecuteCommand);
        return this;
    }

    public Boolean isEnableExecuteCommand() {
        return this.enableExecuteCommand;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public StartTaskRequest withGroup(String group) {
        this.setGroup(group);
        return this;
    }

    public void setNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.networkConfiguration = networkConfiguration;
    }

    public NetworkConfiguration getNetworkConfiguration() {
        return this.networkConfiguration;
    }

    public StartTaskRequest withNetworkConfiguration(NetworkConfiguration networkConfiguration) {
        this.setNetworkConfiguration(networkConfiguration);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public StartTaskRequest withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public void setPropagateTags(String propagateTags) {
        this.propagateTags = propagateTags;
    }

    public String getPropagateTags() {
        return this.propagateTags;
    }

    public StartTaskRequest withPropagateTags(String propagateTags) {
        this.setPropagateTags(propagateTags);
        return this;
    }

    public StartTaskRequest withPropagateTags(PropagateTags propagateTags) {
        this.propagateTags = propagateTags.toString();
        return this;
    }

    public void setReferenceId(String referenceId) {
        this.referenceId = referenceId;
    }

    public String getReferenceId() {
        return this.referenceId;
    }

    public StartTaskRequest withReferenceId(String referenceId) {
        this.setReferenceId(referenceId);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public StartTaskRequest withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public StartTaskRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public StartTaskRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public StartTaskRequest withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public List<TaskVolumeConfiguration> getVolumeConfigurations() {
        if (this.volumeConfigurations == null) {
            this.volumeConfigurations = new SdkInternalList();
        }
        return this.volumeConfigurations;
    }

    public void setVolumeConfigurations(Collection<TaskVolumeConfiguration> volumeConfigurations) {
        if (volumeConfigurations == null) {
            this.volumeConfigurations = null;
            return;
        }
        this.volumeConfigurations = new SdkInternalList(volumeConfigurations);
    }

    public StartTaskRequest withVolumeConfigurations(TaskVolumeConfiguration ... volumeConfigurations) {
        if (this.volumeConfigurations == null) {
            this.setVolumeConfigurations((Collection<TaskVolumeConfiguration>)new SdkInternalList(volumeConfigurations.length));
        }
        for (TaskVolumeConfiguration ele : volumeConfigurations) {
            this.volumeConfigurations.add((Object)ele);
        }
        return this;
    }

    public StartTaskRequest withVolumeConfigurations(Collection<TaskVolumeConfiguration> volumeConfigurations) {
        this.setVolumeConfigurations(volumeConfigurations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getCluster() != null) {
            sb.append("Cluster: ").append(this.getCluster()).append(",");
        }
        if (this.getContainerInstances() != null) {
            sb.append("ContainerInstances: ").append(this.getContainerInstances()).append(",");
        }
        if (this.getEnableECSManagedTags() != null) {
            sb.append("EnableECSManagedTags: ").append(this.getEnableECSManagedTags()).append(",");
        }
        if (this.getEnableExecuteCommand() != null) {
            sb.append("EnableExecuteCommand: ").append(this.getEnableExecuteCommand()).append(",");
        }
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup()).append(",");
        }
        if (this.getNetworkConfiguration() != null) {
            sb.append("NetworkConfiguration: ").append(this.getNetworkConfiguration()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getPropagateTags() != null) {
            sb.append("PropagateTags: ").append(this.getPropagateTags()).append(",");
        }
        if (this.getReferenceId() != null) {
            sb.append("ReferenceId: ").append(this.getReferenceId()).append(",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: ").append(this.getStartedBy()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: ").append(this.getTaskDefinition()).append(",");
        }
        if (this.getVolumeConfigurations() != null) {
            sb.append("VolumeConfigurations: ").append(this.getVolumeConfigurations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartTaskRequest)) {
            return false;
        }
        StartTaskRequest other = (StartTaskRequest)obj;
        if (other.getCluster() == null ^ this.getCluster() == null) {
            return false;
        }
        if (other.getCluster() != null && !other.getCluster().equals(this.getCluster())) {
            return false;
        }
        if (other.getContainerInstances() == null ^ this.getContainerInstances() == null) {
            return false;
        }
        if (other.getContainerInstances() != null && !other.getContainerInstances().equals(this.getContainerInstances())) {
            return false;
        }
        if (other.getEnableECSManagedTags() == null ^ this.getEnableECSManagedTags() == null) {
            return false;
        }
        if (other.getEnableECSManagedTags() != null && !other.getEnableECSManagedTags().equals(this.getEnableECSManagedTags())) {
            return false;
        }
        if (other.getEnableExecuteCommand() == null ^ this.getEnableExecuteCommand() == null) {
            return false;
        }
        if (other.getEnableExecuteCommand() != null && !other.getEnableExecuteCommand().equals(this.getEnableExecuteCommand())) {
            return false;
        }
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getNetworkConfiguration() == null ^ this.getNetworkConfiguration() == null) {
            return false;
        }
        if (other.getNetworkConfiguration() != null && !other.getNetworkConfiguration().equals(this.getNetworkConfiguration())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getPropagateTags() == null ^ this.getPropagateTags() == null) {
            return false;
        }
        if (other.getPropagateTags() != null && !other.getPropagateTags().equals(this.getPropagateTags())) {
            return false;
        }
        if (other.getReferenceId() == null ^ this.getReferenceId() == null) {
            return false;
        }
        if (other.getReferenceId() != null && !other.getReferenceId().equals(this.getReferenceId())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        if (other.getStartedBy() != null && !other.getStartedBy().equals(this.getStartedBy())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getVolumeConfigurations() == null ^ this.getVolumeConfigurations() == null) {
            return false;
        }
        return other.getVolumeConfigurations() == null || other.getVolumeConfigurations().equals(this.getVolumeConfigurations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getCluster() == null ? 0 : this.getCluster().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstances() == null ? 0 : this.getContainerInstances().hashCode());
        hashCode = 31 * hashCode + (this.getEnableECSManagedTags() == null ? 0 : this.getEnableECSManagedTags().hashCode());
        hashCode = 31 * hashCode + (this.getEnableExecuteCommand() == null ? 0 : this.getEnableExecuteCommand().hashCode());
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkConfiguration() == null ? 0 : this.getNetworkConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getPropagateTags() == null ? 0 : this.getPropagateTags().hashCode());
        hashCode = 31 * hashCode + (this.getReferenceId() == null ? 0 : this.getReferenceId().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getVolumeConfigurations() == null ? 0 : this.getVolumeConfigurations().hashCode());
        return hashCode;
    }

    public StartTaskRequest clone() {
        return (StartTaskRequest)super.clone();
    }
}

