/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.EFSAuthorizationConfig;
import com.amazonaws.services.ecs.model.EFSTransitEncryption;
import com.amazonaws.services.ecs.model.transform.EFSVolumeConfigurationMarshaller;
import java.io.Serializable;

public class EFSVolumeConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String fileSystemId;
    private String rootDirectory;
    private String transitEncryption;
    private Integer transitEncryptionPort;
    private EFSAuthorizationConfig authorizationConfig;

    public void setFileSystemId(String fileSystemId) {
        this.fileSystemId = fileSystemId;
    }

    public String getFileSystemId() {
        return this.fileSystemId;
    }

    public EFSVolumeConfiguration withFileSystemId(String fileSystemId) {
        this.setFileSystemId(fileSystemId);
        return this;
    }

    public void setRootDirectory(String rootDirectory) {
        this.rootDirectory = rootDirectory;
    }

    public String getRootDirectory() {
        return this.rootDirectory;
    }

    public EFSVolumeConfiguration withRootDirectory(String rootDirectory) {
        this.setRootDirectory(rootDirectory);
        return this;
    }

    public void setTransitEncryption(String transitEncryption) {
        this.transitEncryption = transitEncryption;
    }

    public String getTransitEncryption() {
        return this.transitEncryption;
    }

    public EFSVolumeConfiguration withTransitEncryption(String transitEncryption) {
        this.setTransitEncryption(transitEncryption);
        return this;
    }

    public EFSVolumeConfiguration withTransitEncryption(EFSTransitEncryption transitEncryption) {
        this.transitEncryption = transitEncryption.toString();
        return this;
    }

    public void setTransitEncryptionPort(Integer transitEncryptionPort) {
        this.transitEncryptionPort = transitEncryptionPort;
    }

    public Integer getTransitEncryptionPort() {
        return this.transitEncryptionPort;
    }

    public EFSVolumeConfiguration withTransitEncryptionPort(Integer transitEncryptionPort) {
        this.setTransitEncryptionPort(transitEncryptionPort);
        return this;
    }

    public void setAuthorizationConfig(EFSAuthorizationConfig authorizationConfig) {
        this.authorizationConfig = authorizationConfig;
    }

    public EFSAuthorizationConfig getAuthorizationConfig() {
        return this.authorizationConfig;
    }

    public EFSVolumeConfiguration withAuthorizationConfig(EFSAuthorizationConfig authorizationConfig) {
        this.setAuthorizationConfig(authorizationConfig);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFileSystemId() != null) {
            sb.append("FileSystemId: ").append(this.getFileSystemId()).append(",");
        }
        if (this.getRootDirectory() != null) {
            sb.append("RootDirectory: ").append(this.getRootDirectory()).append(",");
        }
        if (this.getTransitEncryption() != null) {
            sb.append("TransitEncryption: ").append(this.getTransitEncryption()).append(",");
        }
        if (this.getTransitEncryptionPort() != null) {
            sb.append("TransitEncryptionPort: ").append(this.getTransitEncryptionPort()).append(",");
        }
        if (this.getAuthorizationConfig() != null) {
            sb.append("AuthorizationConfig: ").append(this.getAuthorizationConfig());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EFSVolumeConfiguration)) {
            return false;
        }
        EFSVolumeConfiguration other = (EFSVolumeConfiguration)obj;
        if (other.getFileSystemId() == null ^ this.getFileSystemId() == null) {
            return false;
        }
        if (other.getFileSystemId() != null && !other.getFileSystemId().equals(this.getFileSystemId())) {
            return false;
        }
        if (other.getRootDirectory() == null ^ this.getRootDirectory() == null) {
            return false;
        }
        if (other.getRootDirectory() != null && !other.getRootDirectory().equals(this.getRootDirectory())) {
            return false;
        }
        if (other.getTransitEncryption() == null ^ this.getTransitEncryption() == null) {
            return false;
        }
        if (other.getTransitEncryption() != null && !other.getTransitEncryption().equals(this.getTransitEncryption())) {
            return false;
        }
        if (other.getTransitEncryptionPort() == null ^ this.getTransitEncryptionPort() == null) {
            return false;
        }
        if (other.getTransitEncryptionPort() != null && !other.getTransitEncryptionPort().equals(this.getTransitEncryptionPort())) {
            return false;
        }
        if (other.getAuthorizationConfig() == null ^ this.getAuthorizationConfig() == null) {
            return false;
        }
        return other.getAuthorizationConfig() == null || other.getAuthorizationConfig().equals(this.getAuthorizationConfig());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFileSystemId() == null ? 0 : this.getFileSystemId().hashCode());
        hashCode = 31 * hashCode + (this.getRootDirectory() == null ? 0 : this.getRootDirectory().hashCode());
        hashCode = 31 * hashCode + (this.getTransitEncryption() == null ? 0 : this.getTransitEncryption().hashCode());
        hashCode = 31 * hashCode + (this.getTransitEncryptionPort() == null ? 0 : this.getTransitEncryptionPort().hashCode());
        hashCode = 31 * hashCode + (this.getAuthorizationConfig() == null ? 0 : this.getAuthorizationConfig().hashCode());
        return hashCode;
    }

    public EFSVolumeConfiguration clone() {
        try {
            return (EFSVolumeConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        EFSVolumeConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

