/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.AutoScalingGroupProvider;
import com.amazonaws.services.ecs.model.Tag;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class CreateCapacityProviderRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String name;
    private AutoScalingGroupProvider autoScalingGroupProvider;
    private SdkInternalList<Tag> tags;

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public CreateCapacityProviderRequest withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAutoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider) {
        this.autoScalingGroupProvider = autoScalingGroupProvider;
    }

    public AutoScalingGroupProvider getAutoScalingGroupProvider() {
        return this.autoScalingGroupProvider;
    }

    public CreateCapacityProviderRequest withAutoScalingGroupProvider(AutoScalingGroupProvider autoScalingGroupProvider) {
        this.setAutoScalingGroupProvider(autoScalingGroupProvider);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public CreateCapacityProviderRequest withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public CreateCapacityProviderRequest withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAutoScalingGroupProvider() != null) {
            sb.append("AutoScalingGroupProvider: ").append(this.getAutoScalingGroupProvider()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateCapacityProviderRequest)) {
            return false;
        }
        CreateCapacityProviderRequest other = (CreateCapacityProviderRequest)obj;
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAutoScalingGroupProvider() == null ^ this.getAutoScalingGroupProvider() == null) {
            return false;
        }
        if (other.getAutoScalingGroupProvider() != null && !other.getAutoScalingGroupProvider().equals(this.getAutoScalingGroupProvider())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        return other.getTags() == null || other.getTags().equals(this.getTags());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAutoScalingGroupProvider() == null ? 0 : this.getAutoScalingGroupProvider().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        return hashCode;
    }

    public CreateCapacityProviderRequest clone() {
        return (CreateCapacityProviderRequest)super.clone();
    }
}

