/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.ApplicationProtocol;
import com.amazonaws.services.ecs.model.TransportProtocol;
import com.amazonaws.services.ecs.model.transform.PortMappingMarshaller;
import java.io.Serializable;

public class PortMapping
implements Serializable,
Cloneable,
StructuredPojo {
    private Integer containerPort;
    private Integer hostPort;
    private String protocol;
    private String name;
    private String appProtocol;

    public void setContainerPort(Integer containerPort) {
        this.containerPort = containerPort;
    }

    public Integer getContainerPort() {
        return this.containerPort;
    }

    public PortMapping withContainerPort(Integer containerPort) {
        this.setContainerPort(containerPort);
        return this;
    }

    public void setHostPort(Integer hostPort) {
        this.hostPort = hostPort;
    }

    public Integer getHostPort() {
        return this.hostPort;
    }

    public PortMapping withHostPort(Integer hostPort) {
        this.setHostPort(hostPort);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public PortMapping withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setProtocol(TransportProtocol protocol) {
        this.withProtocol(protocol);
    }

    public PortMapping withProtocol(TransportProtocol protocol) {
        this.protocol = protocol.toString();
        return this;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public PortMapping withName(String name) {
        this.setName(name);
        return this;
    }

    public void setAppProtocol(String appProtocol) {
        this.appProtocol = appProtocol;
    }

    public String getAppProtocol() {
        return this.appProtocol;
    }

    public PortMapping withAppProtocol(String appProtocol) {
        this.setAppProtocol(appProtocol);
        return this;
    }

    public void setAppProtocol(ApplicationProtocol appProtocol) {
        this.withAppProtocol(appProtocol);
    }

    public PortMapping withAppProtocol(ApplicationProtocol appProtocol) {
        this.appProtocol = appProtocol.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getContainerPort() != null) {
            sb.append("ContainerPort: ").append(this.getContainerPort()).append(",");
        }
        if (this.getHostPort() != null) {
            sb.append("HostPort: ").append(this.getHostPort()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getName() != null) {
            sb.append("Name: ").append(this.getName()).append(",");
        }
        if (this.getAppProtocol() != null) {
            sb.append("AppProtocol: ").append(this.getAppProtocol());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PortMapping)) {
            return false;
        }
        PortMapping other = (PortMapping)obj;
        if (other.getContainerPort() == null ^ this.getContainerPort() == null) {
            return false;
        }
        if (other.getContainerPort() != null && !other.getContainerPort().equals(this.getContainerPort())) {
            return false;
        }
        if (other.getHostPort() == null ^ this.getHostPort() == null) {
            return false;
        }
        if (other.getHostPort() != null && !other.getHostPort().equals(this.getHostPort())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getName() == null ^ this.getName() == null) {
            return false;
        }
        if (other.getName() != null && !other.getName().equals(this.getName())) {
            return false;
        }
        if (other.getAppProtocol() == null ^ this.getAppProtocol() == null) {
            return false;
        }
        return other.getAppProtocol() == null || other.getAppProtocol().equals(this.getAppProtocol());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getContainerPort() == null ? 0 : this.getContainerPort().hashCode());
        hashCode = 31 * hashCode + (this.getHostPort() == null ? 0 : this.getHostPort().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getName() == null ? 0 : this.getName().hashCode());
        hashCode = 31 * hashCode + (this.getAppProtocol() == null ? 0 : this.getAppProtocol().hashCode());
        return hashCode;
    }

    public PortMapping clone() {
        try {
            return (PortMapping)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        PortMappingMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

