/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.FirelensConfigurationType;
import com.amazonaws.services.ecs.model.transform.FirelensConfigurationMarshaller;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class FirelensConfiguration
implements Serializable,
Cloneable,
StructuredPojo {
    private String type;
    private Map<String, String> options;

    public void setType(String type) {
        this.type = type;
    }

    public String getType() {
        return this.type;
    }

    public FirelensConfiguration withType(String type) {
        this.setType(type);
        return this;
    }

    public FirelensConfiguration withType(FirelensConfigurationType type) {
        this.type = type.toString();
        return this;
    }

    public Map<String, String> getOptions() {
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public FirelensConfiguration withOptions(Map<String, String> options) {
        this.setOptions(options);
        return this;
    }

    public FirelensConfiguration addOptionsEntry(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        if (this.options.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.options.put(key, value);
        return this;
    }

    public FirelensConfiguration clearOptionsEntries() {
        this.options = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getType() != null) {
            sb.append("Type: ").append(this.getType()).append(",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: ").append(this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirelensConfiguration)) {
            return false;
        }
        FirelensConfiguration other = (FirelensConfiguration)obj;
        if (other.getType() == null ^ this.getType() == null) {
            return false;
        }
        if (other.getType() != null && !other.getType().equals(this.getType())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getType() == null ? 0 : this.getType().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public FirelensConfiguration clone() {
        try {
            return (FirelensConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        FirelensConfigurationMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

