/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecs.model.Attachment;
import com.amazonaws.services.ecs.model.Attribute;
import com.amazonaws.services.ecs.model.Connectivity;
import com.amazonaws.services.ecs.model.Container;
import com.amazonaws.services.ecs.model.HealthStatus;
import com.amazonaws.services.ecs.model.InferenceAccelerator;
import com.amazonaws.services.ecs.model.LaunchType;
import com.amazonaws.services.ecs.model.Tag;
import com.amazonaws.services.ecs.model.TaskOverride;
import com.amazonaws.services.ecs.model.TaskStopCode;
import com.amazonaws.services.ecs.model.transform.TaskMarshaller;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Task
implements Serializable,
Cloneable,
StructuredPojo {
    private SdkInternalList<Attachment> attachments;
    private SdkInternalList<Attribute> attributes;
    private String availabilityZone;
    private String capacityProviderName;
    private String clusterArn;
    private String connectivity;
    private Date connectivityAt;
    private String containerInstanceArn;
    private SdkInternalList<Container> containers;
    private String cpu;
    private Date createdAt;
    private String desiredStatus;
    private Date executionStoppedAt;
    private String group;
    private String healthStatus;
    private SdkInternalList<InferenceAccelerator> inferenceAccelerators;
    private String lastStatus;
    private String launchType;
    private String memory;
    private TaskOverride overrides;
    private String platformVersion;
    private Date pullStartedAt;
    private Date pullStoppedAt;
    private Date startedAt;
    private String startedBy;
    private String stopCode;
    private Date stoppedAt;
    private String stoppedReason;
    private Date stoppingAt;
    private SdkInternalList<Tag> tags;
    private String taskArn;
    private String taskDefinitionArn;
    private Long version;

    public List<Attachment> getAttachments() {
        if (this.attachments == null) {
            this.attachments = new SdkInternalList();
        }
        return this.attachments;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        if (attachments == null) {
            this.attachments = null;
            return;
        }
        this.attachments = new SdkInternalList(attachments);
    }

    public Task withAttachments(Attachment ... attachments) {
        if (this.attachments == null) {
            this.setAttachments((Collection<Attachment>)new SdkInternalList(attachments.length));
        }
        for (Attachment ele : attachments) {
            this.attachments.add((Object)ele);
        }
        return this;
    }

    public Task withAttachments(Collection<Attachment> attachments) {
        this.setAttachments(attachments);
        return this;
    }

    public List<Attribute> getAttributes() {
        if (this.attributes == null) {
            this.attributes = new SdkInternalList();
        }
        return this.attributes;
    }

    public void setAttributes(Collection<Attribute> attributes) {
        if (attributes == null) {
            this.attributes = null;
            return;
        }
        this.attributes = new SdkInternalList(attributes);
    }

    public Task withAttributes(Attribute ... attributes) {
        if (this.attributes == null) {
            this.setAttributes((Collection<Attribute>)new SdkInternalList(attributes.length));
        }
        for (Attribute ele : attributes) {
            this.attributes.add((Object)ele);
        }
        return this;
    }

    public Task withAttributes(Collection<Attribute> attributes) {
        this.setAttributes(attributes);
        return this;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public Task withAvailabilityZone(String availabilityZone) {
        this.setAvailabilityZone(availabilityZone);
        return this;
    }

    public void setCapacityProviderName(String capacityProviderName) {
        this.capacityProviderName = capacityProviderName;
    }

    public String getCapacityProviderName() {
        return this.capacityProviderName;
    }

    public Task withCapacityProviderName(String capacityProviderName) {
        this.setCapacityProviderName(capacityProviderName);
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Task withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public void setConnectivity(String connectivity) {
        this.connectivity = connectivity;
    }

    public String getConnectivity() {
        return this.connectivity;
    }

    public Task withConnectivity(String connectivity) {
        this.setConnectivity(connectivity);
        return this;
    }

    public Task withConnectivity(Connectivity connectivity) {
        this.connectivity = connectivity.toString();
        return this;
    }

    public void setConnectivityAt(Date connectivityAt) {
        this.connectivityAt = connectivityAt;
    }

    public Date getConnectivityAt() {
        return this.connectivityAt;
    }

    public Task withConnectivityAt(Date connectivityAt) {
        this.setConnectivityAt(connectivityAt);
        return this;
    }

    public void setContainerInstanceArn(String containerInstanceArn) {
        this.containerInstanceArn = containerInstanceArn;
    }

    public String getContainerInstanceArn() {
        return this.containerInstanceArn;
    }

    public Task withContainerInstanceArn(String containerInstanceArn) {
        this.setContainerInstanceArn(containerInstanceArn);
        return this;
    }

    public List<Container> getContainers() {
        if (this.containers == null) {
            this.containers = new SdkInternalList();
        }
        return this.containers;
    }

    public void setContainers(Collection<Container> containers) {
        if (containers == null) {
            this.containers = null;
            return;
        }
        this.containers = new SdkInternalList(containers);
    }

    public Task withContainers(Container ... containers) {
        if (this.containers == null) {
            this.setContainers((Collection<Container>)new SdkInternalList(containers.length));
        }
        for (Container ele : containers) {
            this.containers.add((Object)ele);
        }
        return this;
    }

    public Task withContainers(Collection<Container> containers) {
        this.setContainers(containers);
        return this;
    }

    public void setCpu(String cpu) {
        this.cpu = cpu;
    }

    public String getCpu() {
        return this.cpu;
    }

    public Task withCpu(String cpu) {
        this.setCpu(cpu);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Task withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public void setDesiredStatus(String desiredStatus) {
        this.desiredStatus = desiredStatus;
    }

    public String getDesiredStatus() {
        return this.desiredStatus;
    }

    public Task withDesiredStatus(String desiredStatus) {
        this.setDesiredStatus(desiredStatus);
        return this;
    }

    public void setExecutionStoppedAt(Date executionStoppedAt) {
        this.executionStoppedAt = executionStoppedAt;
    }

    public Date getExecutionStoppedAt() {
        return this.executionStoppedAt;
    }

    public Task withExecutionStoppedAt(Date executionStoppedAt) {
        this.setExecutionStoppedAt(executionStoppedAt);
        return this;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getGroup() {
        return this.group;
    }

    public Task withGroup(String group) {
        this.setGroup(group);
        return this;
    }

    public void setHealthStatus(String healthStatus) {
        this.healthStatus = healthStatus;
    }

    public String getHealthStatus() {
        return this.healthStatus;
    }

    public Task withHealthStatus(String healthStatus) {
        this.setHealthStatus(healthStatus);
        return this;
    }

    public Task withHealthStatus(HealthStatus healthStatus) {
        this.healthStatus = healthStatus.toString();
        return this;
    }

    public List<InferenceAccelerator> getInferenceAccelerators() {
        if (this.inferenceAccelerators == null) {
            this.inferenceAccelerators = new SdkInternalList();
        }
        return this.inferenceAccelerators;
    }

    public void setInferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
        if (inferenceAccelerators == null) {
            this.inferenceAccelerators = null;
            return;
        }
        this.inferenceAccelerators = new SdkInternalList(inferenceAccelerators);
    }

    public Task withInferenceAccelerators(InferenceAccelerator ... inferenceAccelerators) {
        if (this.inferenceAccelerators == null) {
            this.setInferenceAccelerators((Collection<InferenceAccelerator>)new SdkInternalList(inferenceAccelerators.length));
        }
        for (InferenceAccelerator ele : inferenceAccelerators) {
            this.inferenceAccelerators.add((Object)ele);
        }
        return this;
    }

    public Task withInferenceAccelerators(Collection<InferenceAccelerator> inferenceAccelerators) {
        this.setInferenceAccelerators(inferenceAccelerators);
        return this;
    }

    public void setLastStatus(String lastStatus) {
        this.lastStatus = lastStatus;
    }

    public String getLastStatus() {
        return this.lastStatus;
    }

    public Task withLastStatus(String lastStatus) {
        this.setLastStatus(lastStatus);
        return this;
    }

    public void setLaunchType(String launchType) {
        this.launchType = launchType;
    }

    public String getLaunchType() {
        return this.launchType;
    }

    public Task withLaunchType(String launchType) {
        this.setLaunchType(launchType);
        return this;
    }

    public Task withLaunchType(LaunchType launchType) {
        this.launchType = launchType.toString();
        return this;
    }

    public void setMemory(String memory) {
        this.memory = memory;
    }

    public String getMemory() {
        return this.memory;
    }

    public Task withMemory(String memory) {
        this.setMemory(memory);
        return this;
    }

    public void setOverrides(TaskOverride overrides) {
        this.overrides = overrides;
    }

    public TaskOverride getOverrides() {
        return this.overrides;
    }

    public Task withOverrides(TaskOverride overrides) {
        this.setOverrides(overrides);
        return this;
    }

    public void setPlatformVersion(String platformVersion) {
        this.platformVersion = platformVersion;
    }

    public String getPlatformVersion() {
        return this.platformVersion;
    }

    public Task withPlatformVersion(String platformVersion) {
        this.setPlatformVersion(platformVersion);
        return this;
    }

    public void setPullStartedAt(Date pullStartedAt) {
        this.pullStartedAt = pullStartedAt;
    }

    public Date getPullStartedAt() {
        return this.pullStartedAt;
    }

    public Task withPullStartedAt(Date pullStartedAt) {
        this.setPullStartedAt(pullStartedAt);
        return this;
    }

    public void setPullStoppedAt(Date pullStoppedAt) {
        this.pullStoppedAt = pullStoppedAt;
    }

    public Date getPullStoppedAt() {
        return this.pullStoppedAt;
    }

    public Task withPullStoppedAt(Date pullStoppedAt) {
        this.setPullStoppedAt(pullStoppedAt);
        return this;
    }

    public void setStartedAt(Date startedAt) {
        this.startedAt = startedAt;
    }

    public Date getStartedAt() {
        return this.startedAt;
    }

    public Task withStartedAt(Date startedAt) {
        this.setStartedAt(startedAt);
        return this;
    }

    public void setStartedBy(String startedBy) {
        this.startedBy = startedBy;
    }

    public String getStartedBy() {
        return this.startedBy;
    }

    public Task withStartedBy(String startedBy) {
        this.setStartedBy(startedBy);
        return this;
    }

    public void setStopCode(String stopCode) {
        this.stopCode = stopCode;
    }

    public String getStopCode() {
        return this.stopCode;
    }

    public Task withStopCode(String stopCode) {
        this.setStopCode(stopCode);
        return this;
    }

    public Task withStopCode(TaskStopCode stopCode) {
        this.stopCode = stopCode.toString();
        return this;
    }

    public void setStoppedAt(Date stoppedAt) {
        this.stoppedAt = stoppedAt;
    }

    public Date getStoppedAt() {
        return this.stoppedAt;
    }

    public Task withStoppedAt(Date stoppedAt) {
        this.setStoppedAt(stoppedAt);
        return this;
    }

    public void setStoppedReason(String stoppedReason) {
        this.stoppedReason = stoppedReason;
    }

    public String getStoppedReason() {
        return this.stoppedReason;
    }

    public Task withStoppedReason(String stoppedReason) {
        this.setStoppedReason(stoppedReason);
        return this;
    }

    public void setStoppingAt(Date stoppingAt) {
        this.stoppingAt = stoppingAt;
    }

    public Date getStoppingAt() {
        return this.stoppingAt;
    }

    public Task withStoppingAt(Date stoppingAt) {
        this.setStoppingAt(stoppingAt);
        return this;
    }

    public List<Tag> getTags() {
        if (this.tags == null) {
            this.tags = new SdkInternalList();
        }
        return this.tags;
    }

    public void setTags(Collection<Tag> tags) {
        if (tags == null) {
            this.tags = null;
            return;
        }
        this.tags = new SdkInternalList(tags);
    }

    public Task withTags(Tag ... tags) {
        if (this.tags == null) {
            this.setTags((Collection<Tag>)new SdkInternalList(tags.length));
        }
        for (Tag ele : tags) {
            this.tags.add((Object)ele);
        }
        return this;
    }

    public Task withTags(Collection<Tag> tags) {
        this.setTags(tags);
        return this;
    }

    public void setTaskArn(String taskArn) {
        this.taskArn = taskArn;
    }

    public String getTaskArn() {
        return this.taskArn;
    }

    public Task withTaskArn(String taskArn) {
        this.setTaskArn(taskArn);
        return this;
    }

    public void setTaskDefinitionArn(String taskDefinitionArn) {
        this.taskDefinitionArn = taskDefinitionArn;
    }

    public String getTaskDefinitionArn() {
        return this.taskDefinitionArn;
    }

    public Task withTaskDefinitionArn(String taskDefinitionArn) {
        this.setTaskDefinitionArn(taskDefinitionArn);
        return this;
    }

    public void setVersion(Long version) {
        this.version = version;
    }

    public Long getVersion() {
        return this.version;
    }

    public Task withVersion(Long version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAttachments() != null) {
            sb.append("Attachments: ").append(this.getAttachments()).append(",");
        }
        if (this.getAttributes() != null) {
            sb.append("Attributes: ").append(this.getAttributes()).append(",");
        }
        if (this.getAvailabilityZone() != null) {
            sb.append("AvailabilityZone: ").append(this.getAvailabilityZone()).append(",");
        }
        if (this.getCapacityProviderName() != null) {
            sb.append("CapacityProviderName: ").append(this.getCapacityProviderName()).append(",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: ").append(this.getClusterArn()).append(",");
        }
        if (this.getConnectivity() != null) {
            sb.append("Connectivity: ").append(this.getConnectivity()).append(",");
        }
        if (this.getConnectivityAt() != null) {
            sb.append("ConnectivityAt: ").append(this.getConnectivityAt()).append(",");
        }
        if (this.getContainerInstanceArn() != null) {
            sb.append("ContainerInstanceArn: ").append(this.getContainerInstanceArn()).append(",");
        }
        if (this.getContainers() != null) {
            sb.append("Containers: ").append(this.getContainers()).append(",");
        }
        if (this.getCpu() != null) {
            sb.append("Cpu: ").append(this.getCpu()).append(",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: ").append(this.getCreatedAt()).append(",");
        }
        if (this.getDesiredStatus() != null) {
            sb.append("DesiredStatus: ").append(this.getDesiredStatus()).append(",");
        }
        if (this.getExecutionStoppedAt() != null) {
            sb.append("ExecutionStoppedAt: ").append(this.getExecutionStoppedAt()).append(",");
        }
        if (this.getGroup() != null) {
            sb.append("Group: ").append(this.getGroup()).append(",");
        }
        if (this.getHealthStatus() != null) {
            sb.append("HealthStatus: ").append(this.getHealthStatus()).append(",");
        }
        if (this.getInferenceAccelerators() != null) {
            sb.append("InferenceAccelerators: ").append(this.getInferenceAccelerators()).append(",");
        }
        if (this.getLastStatus() != null) {
            sb.append("LastStatus: ").append(this.getLastStatus()).append(",");
        }
        if (this.getLaunchType() != null) {
            sb.append("LaunchType: ").append(this.getLaunchType()).append(",");
        }
        if (this.getMemory() != null) {
            sb.append("Memory: ").append(this.getMemory()).append(",");
        }
        if (this.getOverrides() != null) {
            sb.append("Overrides: ").append(this.getOverrides()).append(",");
        }
        if (this.getPlatformVersion() != null) {
            sb.append("PlatformVersion: ").append(this.getPlatformVersion()).append(",");
        }
        if (this.getPullStartedAt() != null) {
            sb.append("PullStartedAt: ").append(this.getPullStartedAt()).append(",");
        }
        if (this.getPullStoppedAt() != null) {
            sb.append("PullStoppedAt: ").append(this.getPullStoppedAt()).append(",");
        }
        if (this.getStartedAt() != null) {
            sb.append("StartedAt: ").append(this.getStartedAt()).append(",");
        }
        if (this.getStartedBy() != null) {
            sb.append("StartedBy: ").append(this.getStartedBy()).append(",");
        }
        if (this.getStopCode() != null) {
            sb.append("StopCode: ").append(this.getStopCode()).append(",");
        }
        if (this.getStoppedAt() != null) {
            sb.append("StoppedAt: ").append(this.getStoppedAt()).append(",");
        }
        if (this.getStoppedReason() != null) {
            sb.append("StoppedReason: ").append(this.getStoppedReason()).append(",");
        }
        if (this.getStoppingAt() != null) {
            sb.append("StoppingAt: ").append(this.getStoppingAt()).append(",");
        }
        if (this.getTags() != null) {
            sb.append("Tags: ").append(this.getTags()).append(",");
        }
        if (this.getTaskArn() != null) {
            sb.append("TaskArn: ").append(this.getTaskArn()).append(",");
        }
        if (this.getTaskDefinitionArn() != null) {
            sb.append("TaskDefinitionArn: ").append(this.getTaskDefinitionArn()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Task)) {
            return false;
        }
        Task other = (Task)obj;
        if (other.getAttachments() == null ^ this.getAttachments() == null) {
            return false;
        }
        if (other.getAttachments() != null && !other.getAttachments().equals(this.getAttachments())) {
            return false;
        }
        if (other.getAttributes() == null ^ this.getAttributes() == null) {
            return false;
        }
        if (other.getAttributes() != null && !other.getAttributes().equals(this.getAttributes())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getCapacityProviderName() == null ^ this.getCapacityProviderName() == null) {
            return false;
        }
        if (other.getCapacityProviderName() != null && !other.getCapacityProviderName().equals(this.getCapacityProviderName())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getConnectivity() == null ^ this.getConnectivity() == null) {
            return false;
        }
        if (other.getConnectivity() != null && !other.getConnectivity().equals(this.getConnectivity())) {
            return false;
        }
        if (other.getConnectivityAt() == null ^ this.getConnectivityAt() == null) {
            return false;
        }
        if (other.getConnectivityAt() != null && !other.getConnectivityAt().equals(this.getConnectivityAt())) {
            return false;
        }
        if (other.getContainerInstanceArn() == null ^ this.getContainerInstanceArn() == null) {
            return false;
        }
        if (other.getContainerInstanceArn() != null && !other.getContainerInstanceArn().equals(this.getContainerInstanceArn())) {
            return false;
        }
        if (other.getContainers() == null ^ this.getContainers() == null) {
            return false;
        }
        if (other.getContainers() != null && !other.getContainers().equals(this.getContainers())) {
            return false;
        }
        if (other.getCpu() == null ^ this.getCpu() == null) {
            return false;
        }
        if (other.getCpu() != null && !other.getCpu().equals(this.getCpu())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        if (other.getCreatedAt() != null && !other.getCreatedAt().equals(this.getCreatedAt())) {
            return false;
        }
        if (other.getDesiredStatus() == null ^ this.getDesiredStatus() == null) {
            return false;
        }
        if (other.getDesiredStatus() != null && !other.getDesiredStatus().equals(this.getDesiredStatus())) {
            return false;
        }
        if (other.getExecutionStoppedAt() == null ^ this.getExecutionStoppedAt() == null) {
            return false;
        }
        if (other.getExecutionStoppedAt() != null && !other.getExecutionStoppedAt().equals(this.getExecutionStoppedAt())) {
            return false;
        }
        if (other.getGroup() == null ^ this.getGroup() == null) {
            return false;
        }
        if (other.getGroup() != null && !other.getGroup().equals(this.getGroup())) {
            return false;
        }
        if (other.getHealthStatus() == null ^ this.getHealthStatus() == null) {
            return false;
        }
        if (other.getHealthStatus() != null && !other.getHealthStatus().equals(this.getHealthStatus())) {
            return false;
        }
        if (other.getInferenceAccelerators() == null ^ this.getInferenceAccelerators() == null) {
            return false;
        }
        if (other.getInferenceAccelerators() != null && !other.getInferenceAccelerators().equals(this.getInferenceAccelerators())) {
            return false;
        }
        if (other.getLastStatus() == null ^ this.getLastStatus() == null) {
            return false;
        }
        if (other.getLastStatus() != null && !other.getLastStatus().equals(this.getLastStatus())) {
            return false;
        }
        if (other.getLaunchType() == null ^ this.getLaunchType() == null) {
            return false;
        }
        if (other.getLaunchType() != null && !other.getLaunchType().equals(this.getLaunchType())) {
            return false;
        }
        if (other.getMemory() == null ^ this.getMemory() == null) {
            return false;
        }
        if (other.getMemory() != null && !other.getMemory().equals(this.getMemory())) {
            return false;
        }
        if (other.getOverrides() == null ^ this.getOverrides() == null) {
            return false;
        }
        if (other.getOverrides() != null && !other.getOverrides().equals(this.getOverrides())) {
            return false;
        }
        if (other.getPlatformVersion() == null ^ this.getPlatformVersion() == null) {
            return false;
        }
        if (other.getPlatformVersion() != null && !other.getPlatformVersion().equals(this.getPlatformVersion())) {
            return false;
        }
        if (other.getPullStartedAt() == null ^ this.getPullStartedAt() == null) {
            return false;
        }
        if (other.getPullStartedAt() != null && !other.getPullStartedAt().equals(this.getPullStartedAt())) {
            return false;
        }
        if (other.getPullStoppedAt() == null ^ this.getPullStoppedAt() == null) {
            return false;
        }
        if (other.getPullStoppedAt() != null && !other.getPullStoppedAt().equals(this.getPullStoppedAt())) {
            return false;
        }
        if (other.getStartedAt() == null ^ this.getStartedAt() == null) {
            return false;
        }
        if (other.getStartedAt() != null && !other.getStartedAt().equals(this.getStartedAt())) {
            return false;
        }
        if (other.getStartedBy() == null ^ this.getStartedBy() == null) {
            return false;
        }
        if (other.getStartedBy() != null && !other.getStartedBy().equals(this.getStartedBy())) {
            return false;
        }
        if (other.getStopCode() == null ^ this.getStopCode() == null) {
            return false;
        }
        if (other.getStopCode() != null && !other.getStopCode().equals(this.getStopCode())) {
            return false;
        }
        if (other.getStoppedAt() == null ^ this.getStoppedAt() == null) {
            return false;
        }
        if (other.getStoppedAt() != null && !other.getStoppedAt().equals(this.getStoppedAt())) {
            return false;
        }
        if (other.getStoppedReason() == null ^ this.getStoppedReason() == null) {
            return false;
        }
        if (other.getStoppedReason() != null && !other.getStoppedReason().equals(this.getStoppedReason())) {
            return false;
        }
        if (other.getStoppingAt() == null ^ this.getStoppingAt() == null) {
            return false;
        }
        if (other.getStoppingAt() != null && !other.getStoppingAt().equals(this.getStoppingAt())) {
            return false;
        }
        if (other.getTags() == null ^ this.getTags() == null) {
            return false;
        }
        if (other.getTags() != null && !other.getTags().equals(this.getTags())) {
            return false;
        }
        if (other.getTaskArn() == null ^ this.getTaskArn() == null) {
            return false;
        }
        if (other.getTaskArn() != null && !other.getTaskArn().equals(this.getTaskArn())) {
            return false;
        }
        if (other.getTaskDefinitionArn() == null ^ this.getTaskDefinitionArn() == null) {
            return false;
        }
        if (other.getTaskDefinitionArn() != null && !other.getTaskDefinitionArn().equals(this.getTaskDefinitionArn())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAttachments() == null ? 0 : this.getAttachments().hashCode());
        hashCode = 31 * hashCode + (this.getAttributes() == null ? 0 : this.getAttributes().hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getCapacityProviderName() == null ? 0 : this.getCapacityProviderName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getConnectivity() == null ? 0 : this.getConnectivity().hashCode());
        hashCode = 31 * hashCode + (this.getConnectivityAt() == null ? 0 : this.getConnectivityAt().hashCode());
        hashCode = 31 * hashCode + (this.getContainerInstanceArn() == null ? 0 : this.getContainerInstanceArn().hashCode());
        hashCode = 31 * hashCode + (this.getContainers() == null ? 0 : this.getContainers().hashCode());
        hashCode = 31 * hashCode + (this.getCpu() == null ? 0 : this.getCpu().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredStatus() == null ? 0 : this.getDesiredStatus().hashCode());
        hashCode = 31 * hashCode + (this.getExecutionStoppedAt() == null ? 0 : this.getExecutionStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getGroup() == null ? 0 : this.getGroup().hashCode());
        hashCode = 31 * hashCode + (this.getHealthStatus() == null ? 0 : this.getHealthStatus().hashCode());
        hashCode = 31 * hashCode + (this.getInferenceAccelerators() == null ? 0 : this.getInferenceAccelerators().hashCode());
        hashCode = 31 * hashCode + (this.getLastStatus() == null ? 0 : this.getLastStatus().hashCode());
        hashCode = 31 * hashCode + (this.getLaunchType() == null ? 0 : this.getLaunchType().hashCode());
        hashCode = 31 * hashCode + (this.getMemory() == null ? 0 : this.getMemory().hashCode());
        hashCode = 31 * hashCode + (this.getOverrides() == null ? 0 : this.getOverrides().hashCode());
        hashCode = 31 * hashCode + (this.getPlatformVersion() == null ? 0 : this.getPlatformVersion().hashCode());
        hashCode = 31 * hashCode + (this.getPullStartedAt() == null ? 0 : this.getPullStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getPullStoppedAt() == null ? 0 : this.getPullStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStartedAt() == null ? 0 : this.getStartedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStartedBy() == null ? 0 : this.getStartedBy().hashCode());
        hashCode = 31 * hashCode + (this.getStopCode() == null ? 0 : this.getStopCode().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedAt() == null ? 0 : this.getStoppedAt().hashCode());
        hashCode = 31 * hashCode + (this.getStoppedReason() == null ? 0 : this.getStoppedReason().hashCode());
        hashCode = 31 * hashCode + (this.getStoppingAt() == null ? 0 : this.getStoppingAt().hashCode());
        hashCode = 31 * hashCode + (this.getTags() == null ? 0 : this.getTags().hashCode());
        hashCode = 31 * hashCode + (this.getTaskArn() == null ? 0 : this.getTaskArn().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinitionArn() == null ? 0 : this.getTaskDefinitionArn().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public Task clone() {
        try {
            return (Task)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        TaskMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

