/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.Deployment;
import com.amazonaws.services.ecs.model.DeploymentConfiguration;
import com.amazonaws.services.ecs.model.LoadBalancer;
import com.amazonaws.services.ecs.model.ServiceEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.List;

public class Service
implements Serializable,
Cloneable {
    private String serviceArn;
    private String serviceName;
    private String clusterArn;
    private SdkInternalList<LoadBalancer> loadBalancers;
    private String status;
    private Integer desiredCount;
    private Integer runningCount;
    private Integer pendingCount;
    private String taskDefinition;
    private DeploymentConfiguration deploymentConfiguration;
    private SdkInternalList<Deployment> deployments;
    private String roleArn;
    private SdkInternalList<ServiceEvent> events;
    private Date createdAt;

    public void setServiceArn(String serviceArn) {
        this.serviceArn = serviceArn;
    }

    public String getServiceArn() {
        return this.serviceArn;
    }

    public Service withServiceArn(String serviceArn) {
        this.setServiceArn(serviceArn);
        return this;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public Service withServiceName(String serviceName) {
        this.setServiceName(serviceName);
        return this;
    }

    public void setClusterArn(String clusterArn) {
        this.clusterArn = clusterArn;
    }

    public String getClusterArn() {
        return this.clusterArn;
    }

    public Service withClusterArn(String clusterArn) {
        this.setClusterArn(clusterArn);
        return this;
    }

    public List<LoadBalancer> getLoadBalancers() {
        if (this.loadBalancers == null) {
            this.loadBalancers = new SdkInternalList();
        }
        return this.loadBalancers;
    }

    public void setLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        if (loadBalancers == null) {
            this.loadBalancers = null;
            return;
        }
        this.loadBalancers = new SdkInternalList(loadBalancers);
    }

    public Service withLoadBalancers(LoadBalancer ... loadBalancers) {
        if (this.loadBalancers == null) {
            this.setLoadBalancers((Collection<LoadBalancer>)new SdkInternalList(loadBalancers.length));
        }
        for (LoadBalancer ele : loadBalancers) {
            this.loadBalancers.add((Object)ele);
        }
        return this;
    }

    public Service withLoadBalancers(Collection<LoadBalancer> loadBalancers) {
        this.setLoadBalancers(loadBalancers);
        return this;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public Service withStatus(String status) {
        this.setStatus(status);
        return this;
    }

    public void setDesiredCount(Integer desiredCount) {
        this.desiredCount = desiredCount;
    }

    public Integer getDesiredCount() {
        return this.desiredCount;
    }

    public Service withDesiredCount(Integer desiredCount) {
        this.setDesiredCount(desiredCount);
        return this;
    }

    public void setRunningCount(Integer runningCount) {
        this.runningCount = runningCount;
    }

    public Integer getRunningCount() {
        return this.runningCount;
    }

    public Service withRunningCount(Integer runningCount) {
        this.setRunningCount(runningCount);
        return this;
    }

    public void setPendingCount(Integer pendingCount) {
        this.pendingCount = pendingCount;
    }

    public Integer getPendingCount() {
        return this.pendingCount;
    }

    public Service withPendingCount(Integer pendingCount) {
        this.setPendingCount(pendingCount);
        return this;
    }

    public void setTaskDefinition(String taskDefinition) {
        this.taskDefinition = taskDefinition;
    }

    public String getTaskDefinition() {
        return this.taskDefinition;
    }

    public Service withTaskDefinition(String taskDefinition) {
        this.setTaskDefinition(taskDefinition);
        return this;
    }

    public void setDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.deploymentConfiguration = deploymentConfiguration;
    }

    public DeploymentConfiguration getDeploymentConfiguration() {
        return this.deploymentConfiguration;
    }

    public Service withDeploymentConfiguration(DeploymentConfiguration deploymentConfiguration) {
        this.setDeploymentConfiguration(deploymentConfiguration);
        return this;
    }

    public List<Deployment> getDeployments() {
        if (this.deployments == null) {
            this.deployments = new SdkInternalList();
        }
        return this.deployments;
    }

    public void setDeployments(Collection<Deployment> deployments) {
        if (deployments == null) {
            this.deployments = null;
            return;
        }
        this.deployments = new SdkInternalList(deployments);
    }

    public Service withDeployments(Deployment ... deployments) {
        if (this.deployments == null) {
            this.setDeployments((Collection<Deployment>)new SdkInternalList(deployments.length));
        }
        for (Deployment ele : deployments) {
            this.deployments.add((Object)ele);
        }
        return this;
    }

    public Service withDeployments(Collection<Deployment> deployments) {
        this.setDeployments(deployments);
        return this;
    }

    public void setRoleArn(String roleArn) {
        this.roleArn = roleArn;
    }

    public String getRoleArn() {
        return this.roleArn;
    }

    public Service withRoleArn(String roleArn) {
        this.setRoleArn(roleArn);
        return this;
    }

    public List<ServiceEvent> getEvents() {
        if (this.events == null) {
            this.events = new SdkInternalList();
        }
        return this.events;
    }

    public void setEvents(Collection<ServiceEvent> events) {
        if (events == null) {
            this.events = null;
            return;
        }
        this.events = new SdkInternalList(events);
    }

    public Service withEvents(ServiceEvent ... events) {
        if (this.events == null) {
            this.setEvents((Collection<ServiceEvent>)new SdkInternalList(events.length));
        }
        for (ServiceEvent ele : events) {
            this.events.add((Object)ele);
        }
        return this;
    }

    public Service withEvents(Collection<ServiceEvent> events) {
        this.setEvents(events);
        return this;
    }

    public void setCreatedAt(Date createdAt) {
        this.createdAt = createdAt;
    }

    public Date getCreatedAt() {
        return this.createdAt;
    }

    public Service withCreatedAt(Date createdAt) {
        this.setCreatedAt(createdAt);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getServiceArn() != null) {
            sb.append("ServiceArn: " + this.getServiceArn() + ",");
        }
        if (this.getServiceName() != null) {
            sb.append("ServiceName: " + this.getServiceName() + ",");
        }
        if (this.getClusterArn() != null) {
            sb.append("ClusterArn: " + this.getClusterArn() + ",");
        }
        if (this.getLoadBalancers() != null) {
            sb.append("LoadBalancers: " + this.getLoadBalancers() + ",");
        }
        if (this.getStatus() != null) {
            sb.append("Status: " + this.getStatus() + ",");
        }
        if (this.getDesiredCount() != null) {
            sb.append("DesiredCount: " + this.getDesiredCount() + ",");
        }
        if (this.getRunningCount() != null) {
            sb.append("RunningCount: " + this.getRunningCount() + ",");
        }
        if (this.getPendingCount() != null) {
            sb.append("PendingCount: " + this.getPendingCount() + ",");
        }
        if (this.getTaskDefinition() != null) {
            sb.append("TaskDefinition: " + this.getTaskDefinition() + ",");
        }
        if (this.getDeploymentConfiguration() != null) {
            sb.append("DeploymentConfiguration: " + this.getDeploymentConfiguration() + ",");
        }
        if (this.getDeployments() != null) {
            sb.append("Deployments: " + this.getDeployments() + ",");
        }
        if (this.getRoleArn() != null) {
            sb.append("RoleArn: " + this.getRoleArn() + ",");
        }
        if (this.getEvents() != null) {
            sb.append("Events: " + this.getEvents() + ",");
        }
        if (this.getCreatedAt() != null) {
            sb.append("CreatedAt: " + this.getCreatedAt());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service)obj;
        if (other.getServiceArn() == null ^ this.getServiceArn() == null) {
            return false;
        }
        if (other.getServiceArn() != null && !other.getServiceArn().equals(this.getServiceArn())) {
            return false;
        }
        if (other.getServiceName() == null ^ this.getServiceName() == null) {
            return false;
        }
        if (other.getServiceName() != null && !other.getServiceName().equals(this.getServiceName())) {
            return false;
        }
        if (other.getClusterArn() == null ^ this.getClusterArn() == null) {
            return false;
        }
        if (other.getClusterArn() != null && !other.getClusterArn().equals(this.getClusterArn())) {
            return false;
        }
        if (other.getLoadBalancers() == null ^ this.getLoadBalancers() == null) {
            return false;
        }
        if (other.getLoadBalancers() != null && !other.getLoadBalancers().equals(this.getLoadBalancers())) {
            return false;
        }
        if (other.getStatus() == null ^ this.getStatus() == null) {
            return false;
        }
        if (other.getStatus() != null && !other.getStatus().equals(this.getStatus())) {
            return false;
        }
        if (other.getDesiredCount() == null ^ this.getDesiredCount() == null) {
            return false;
        }
        if (other.getDesiredCount() != null && !other.getDesiredCount().equals(this.getDesiredCount())) {
            return false;
        }
        if (other.getRunningCount() == null ^ this.getRunningCount() == null) {
            return false;
        }
        if (other.getRunningCount() != null && !other.getRunningCount().equals(this.getRunningCount())) {
            return false;
        }
        if (other.getPendingCount() == null ^ this.getPendingCount() == null) {
            return false;
        }
        if (other.getPendingCount() != null && !other.getPendingCount().equals(this.getPendingCount())) {
            return false;
        }
        if (other.getTaskDefinition() == null ^ this.getTaskDefinition() == null) {
            return false;
        }
        if (other.getTaskDefinition() != null && !other.getTaskDefinition().equals(this.getTaskDefinition())) {
            return false;
        }
        if (other.getDeploymentConfiguration() == null ^ this.getDeploymentConfiguration() == null) {
            return false;
        }
        if (other.getDeploymentConfiguration() != null && !other.getDeploymentConfiguration().equals(this.getDeploymentConfiguration())) {
            return false;
        }
        if (other.getDeployments() == null ^ this.getDeployments() == null) {
            return false;
        }
        if (other.getDeployments() != null && !other.getDeployments().equals(this.getDeployments())) {
            return false;
        }
        if (other.getRoleArn() == null ^ this.getRoleArn() == null) {
            return false;
        }
        if (other.getRoleArn() != null && !other.getRoleArn().equals(this.getRoleArn())) {
            return false;
        }
        if (other.getEvents() == null ^ this.getEvents() == null) {
            return false;
        }
        if (other.getEvents() != null && !other.getEvents().equals(this.getEvents())) {
            return false;
        }
        if (other.getCreatedAt() == null ^ this.getCreatedAt() == null) {
            return false;
        }
        return other.getCreatedAt() == null || other.getCreatedAt().equals(this.getCreatedAt());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getServiceArn() == null ? 0 : this.getServiceArn().hashCode());
        hashCode = 31 * hashCode + (this.getServiceName() == null ? 0 : this.getServiceName().hashCode());
        hashCode = 31 * hashCode + (this.getClusterArn() == null ? 0 : this.getClusterArn().hashCode());
        hashCode = 31 * hashCode + (this.getLoadBalancers() == null ? 0 : this.getLoadBalancers().hashCode());
        hashCode = 31 * hashCode + (this.getStatus() == null ? 0 : this.getStatus().hashCode());
        hashCode = 31 * hashCode + (this.getDesiredCount() == null ? 0 : this.getDesiredCount().hashCode());
        hashCode = 31 * hashCode + (this.getRunningCount() == null ? 0 : this.getRunningCount().hashCode());
        hashCode = 31 * hashCode + (this.getPendingCount() == null ? 0 : this.getPendingCount().hashCode());
        hashCode = 31 * hashCode + (this.getTaskDefinition() == null ? 0 : this.getTaskDefinition().hashCode());
        hashCode = 31 * hashCode + (this.getDeploymentConfiguration() == null ? 0 : this.getDeploymentConfiguration().hashCode());
        hashCode = 31 * hashCode + (this.getDeployments() == null ? 0 : this.getDeployments().hashCode());
        hashCode = 31 * hashCode + (this.getRoleArn() == null ? 0 : this.getRoleArn().hashCode());
        hashCode = 31 * hashCode + (this.getEvents() == null ? 0 : this.getEvents().hashCode());
        hashCode = 31 * hashCode + (this.getCreatedAt() == null ? 0 : this.getCreatedAt().hashCode());
        return hashCode;
    }

    public Service clone() {
        try {
            return (Service)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

