/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.HostEntry;
import com.amazonaws.services.ecs.model.KeyValuePair;
import com.amazonaws.services.ecs.model.MountPoint;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.services.ecs.model.Ulimit;
import com.amazonaws.services.ecs.model.VolumeFrom;
import com.amazonaws.services.ecs.model.transform.HostEntryJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.KeyValuePairJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.LogConfigurationJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.MountPointJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.PortMappingJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.UlimitJsonMarshaller;
import com.amazonaws.services.ecs.model.transform.VolumeFromJsonMarshaller;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.util.Map;

public class ContainerDefinitionJsonMarshaller {
    private static ContainerDefinitionJsonMarshaller instance;

    public void marshall(ContainerDefinition containerDefinition, StructuredJsonGenerator jsonGenerator) {
        if (containerDefinition == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            SdkInternalList ulimitsList;
            Map<String, String> dockerLabelsMap;
            SdkInternalList dockerSecurityOptionsList;
            SdkInternalList extraHostsList;
            SdkInternalList dnsSearchDomainsList;
            SdkInternalList dnsServersList;
            SdkInternalList volumesFromList;
            SdkInternalList mountPointsList;
            SdkInternalList environmentList;
            SdkInternalList commandList;
            SdkInternalList entryPointList;
            SdkInternalList portMappingsList;
            SdkInternalList linksList;
            jsonGenerator.writeStartObject();
            if (containerDefinition.getName() != null) {
                jsonGenerator.writeFieldName("name").writeValue(containerDefinition.getName());
            }
            if (containerDefinition.getImage() != null) {
                jsonGenerator.writeFieldName("image").writeValue(containerDefinition.getImage());
            }
            if (containerDefinition.getCpu() != null) {
                jsonGenerator.writeFieldName("cpu").writeValue(containerDefinition.getCpu().intValue());
            }
            if (containerDefinition.getMemory() != null) {
                jsonGenerator.writeFieldName("memory").writeValue(containerDefinition.getMemory().intValue());
            }
            if (!(linksList = (SdkInternalList)containerDefinition.getLinks()).isEmpty() || !linksList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("links");
                jsonGenerator.writeStartArray();
                for (Object linksListValue : linksList) {
                    if (linksListValue == null) continue;
                    jsonGenerator.writeValue((String)linksListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(portMappingsList = (SdkInternalList)containerDefinition.getPortMappings()).isEmpty() || !portMappingsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("portMappings");
                jsonGenerator.writeStartArray();
                for (Object portMappingsListValue : portMappingsList) {
                    if (portMappingsListValue == null) continue;
                    PortMappingJsonMarshaller.getInstance().marshall((PortMapping)portMappingsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDefinition.getEssential() != null) {
                jsonGenerator.writeFieldName("essential").writeValue(containerDefinition.getEssential().booleanValue());
            }
            if (!(entryPointList = (SdkInternalList)containerDefinition.getEntryPoint()).isEmpty() || !entryPointList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("entryPoint");
                jsonGenerator.writeStartArray();
                for (Object entryPointListValue : entryPointList) {
                    if (entryPointListValue == null) continue;
                    jsonGenerator.writeValue((String)entryPointListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(commandList = (SdkInternalList)containerDefinition.getCommand()).isEmpty() || !commandList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("command");
                jsonGenerator.writeStartArray();
                for (Object commandListValue : commandList) {
                    if (commandListValue == null) continue;
                    jsonGenerator.writeValue((String)commandListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(environmentList = (SdkInternalList)containerDefinition.getEnvironment()).isEmpty() || !environmentList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("environment");
                jsonGenerator.writeStartArray();
                for (Object environmentListValue : environmentList) {
                    if (environmentListValue == null) continue;
                    KeyValuePairJsonMarshaller.getInstance().marshall((KeyValuePair)environmentListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(mountPointsList = (SdkInternalList)containerDefinition.getMountPoints()).isEmpty() || !mountPointsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("mountPoints");
                jsonGenerator.writeStartArray();
                for (Object mountPointsListValue : mountPointsList) {
                    if (mountPointsListValue == null) continue;
                    MountPointJsonMarshaller.getInstance().marshall((MountPoint)mountPointsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(volumesFromList = (SdkInternalList)containerDefinition.getVolumesFrom()).isEmpty() || !volumesFromList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("volumesFrom");
                jsonGenerator.writeStartArray();
                for (Object volumesFromListValue : volumesFromList) {
                    if (volumesFromListValue == null) continue;
                    VolumeFromJsonMarshaller.getInstance().marshall((VolumeFrom)volumesFromListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDefinition.getHostname() != null) {
                jsonGenerator.writeFieldName("hostname").writeValue(containerDefinition.getHostname());
            }
            if (containerDefinition.getUser() != null) {
                jsonGenerator.writeFieldName("user").writeValue(containerDefinition.getUser());
            }
            if (containerDefinition.getWorkingDirectory() != null) {
                jsonGenerator.writeFieldName("workingDirectory").writeValue(containerDefinition.getWorkingDirectory());
            }
            if (containerDefinition.getDisableNetworking() != null) {
                jsonGenerator.writeFieldName("disableNetworking").writeValue(containerDefinition.getDisableNetworking().booleanValue());
            }
            if (containerDefinition.getPrivileged() != null) {
                jsonGenerator.writeFieldName("privileged").writeValue(containerDefinition.getPrivileged().booleanValue());
            }
            if (containerDefinition.getReadonlyRootFilesystem() != null) {
                jsonGenerator.writeFieldName("readonlyRootFilesystem").writeValue(containerDefinition.getReadonlyRootFilesystem().booleanValue());
            }
            if (!(dnsServersList = (SdkInternalList)containerDefinition.getDnsServers()).isEmpty() || !dnsServersList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("dnsServers");
                jsonGenerator.writeStartArray();
                for (Object dnsServersListValue : dnsServersList) {
                    if (dnsServersListValue == null) continue;
                    jsonGenerator.writeValue((String)dnsServersListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(dnsSearchDomainsList = (SdkInternalList)containerDefinition.getDnsSearchDomains()).isEmpty() || !dnsSearchDomainsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("dnsSearchDomains");
                jsonGenerator.writeStartArray();
                for (Object dnsSearchDomainsListValue : dnsSearchDomainsList) {
                    if (dnsSearchDomainsListValue == null) continue;
                    jsonGenerator.writeValue((String)dnsSearchDomainsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(extraHostsList = (SdkInternalList)containerDefinition.getExtraHosts()).isEmpty() || !extraHostsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("extraHosts");
                jsonGenerator.writeStartArray();
                for (Object extraHostsListValue : extraHostsList) {
                    if (extraHostsListValue == null) continue;
                    HostEntryJsonMarshaller.getInstance().marshall((HostEntry)extraHostsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (!(dockerSecurityOptionsList = (SdkInternalList)containerDefinition.getDockerSecurityOptions()).isEmpty() || !dockerSecurityOptionsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("dockerSecurityOptions");
                jsonGenerator.writeStartArray();
                for (Object dockerSecurityOptionsListValue : dockerSecurityOptionsList) {
                    if (dockerSecurityOptionsListValue == null) continue;
                    jsonGenerator.writeValue((String)dockerSecurityOptionsListValue);
                }
                jsonGenerator.writeEndArray();
            }
            if ((dockerLabelsMap = containerDefinition.getDockerLabels()) != null) {
                jsonGenerator.writeFieldName("dockerLabels");
                jsonGenerator.writeStartObject();
                for (Map.Entry entry : dockerLabelsMap.entrySet()) {
                    if (entry.getValue() == null) continue;
                    jsonGenerator.writeFieldName((String)entry.getKey());
                    jsonGenerator.writeValue((String)entry.getValue());
                }
                jsonGenerator.writeEndObject();
            }
            if (!(ulimitsList = (SdkInternalList)containerDefinition.getUlimits()).isEmpty() || !ulimitsList.isAutoConstruct()) {
                jsonGenerator.writeFieldName("ulimits");
                jsonGenerator.writeStartArray();
                for (Ulimit ulimitsListValue : ulimitsList) {
                    if (ulimitsListValue == null) continue;
                    UlimitJsonMarshaller.getInstance().marshall(ulimitsListValue, jsonGenerator);
                }
                jsonGenerator.writeEndArray();
            }
            if (containerDefinition.getLogConfiguration() != null) {
                jsonGenerator.writeFieldName("logConfiguration");
                LogConfigurationJsonMarshaller.getInstance().marshall(containerDefinition.getLogConfiguration(), jsonGenerator);
            }
            jsonGenerator.writeEndObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static ContainerDefinitionJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new ContainerDefinitionJsonMarshaller();
        }
        return instance;
    }
}

