/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ecs.model.SubmitTaskStateChangeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.json.SdkJsonProtocolFactory;
import com.amazonaws.util.json.StructuredJsonGenerator;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class SubmitTaskStateChangeRequestMarshaller
implements Marshaller<Request<SubmitTaskStateChangeRequest>, SubmitTaskStateChangeRequest> {
    public Request<SubmitTaskStateChangeRequest> marshall(SubmitTaskStateChangeRequest submitTaskStateChangeRequest) {
        if (submitTaskStateChangeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)submitTaskStateChangeRequest, "AmazonECS");
        request.addHeader("X-Amz-Target", "AmazonEC2ContainerServiceV20141113.SubmitTaskStateChange");
        request.setHttpMethod(HttpMethodName.POST);
        request.setResourcePath("");
        try {
            StructuredJsonGenerator jsonGenerator = SdkJsonProtocolFactory.createWriter((boolean)false, (String)"1.1");
            jsonGenerator.writeStartObject();
            if (submitTaskStateChangeRequest.getCluster() != null) {
                jsonGenerator.writeFieldName("cluster").writeValue(submitTaskStateChangeRequest.getCluster());
            }
            if (submitTaskStateChangeRequest.getTask() != null) {
                jsonGenerator.writeFieldName("task").writeValue(submitTaskStateChangeRequest.getTask());
            }
            if (submitTaskStateChangeRequest.getStatus() != null) {
                jsonGenerator.writeFieldName("status").writeValue(submitTaskStateChangeRequest.getStatus());
            }
            if (submitTaskStateChangeRequest.getReason() != null) {
                jsonGenerator.writeFieldName("reason").writeValue(submitTaskStateChangeRequest.getReason());
            }
            jsonGenerator.writeEndObject();
            byte[] content = jsonGenerator.getBytes();
            request.setContent((InputStream)new ByteArrayInputStream(content));
            request.addHeader("Content-Length", Integer.toString(content.length));
            request.addHeader("Content-Type", jsonGenerator.getContentType());
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
        return request;
    }
}

