/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.LogConfiguration;
import com.amazonaws.util.json.JSONWriter;
import java.util.Map;

public class LogConfigurationJsonMarshaller {
    private static LogConfigurationJsonMarshaller instance;

    public void marshall(LogConfiguration logConfiguration, JSONWriter jsonWriter) {
        if (logConfiguration == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            Map<String, String> optionsMap;
            jsonWriter.object();
            if (logConfiguration.getLogDriver() != null) {
                jsonWriter.key("logDriver").value((Object)logConfiguration.getLogDriver());
            }
            if ((optionsMap = logConfiguration.getOptions()) != null) {
                jsonWriter.key("options");
                jsonWriter.object();
                for (Map.Entry<String, String> optionsMapValue : optionsMap.entrySet()) {
                    if (optionsMapValue.getValue() == null) continue;
                    jsonWriter.key(optionsMapValue.getKey());
                    jsonWriter.value((Object)optionsMapValue.getValue());
                }
                jsonWriter.endObject();
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static LogConfigurationJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new LogConfigurationJsonMarshaller();
        }
        return instance;
    }
}

