/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ecs.model.ContainerDefinition;
import com.amazonaws.services.ecs.model.Volume;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class RegisterTaskDefinitionRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private String family;
    private ListWithAutoConstructFlag<ContainerDefinition> containerDefinitions;
    private ListWithAutoConstructFlag<Volume> volumes;

    public String getFamily() {
        return this.family;
    }

    public void setFamily(String family) {
        this.family = family;
    }

    public RegisterTaskDefinitionRequest withFamily(String family) {
        this.family = family;
        return this;
    }

    public List<ContainerDefinition> getContainerDefinitions() {
        if (this.containerDefinitions == null) {
            this.containerDefinitions = new ListWithAutoConstructFlag();
            this.containerDefinitions.setAutoConstruct(true);
        }
        return this.containerDefinitions;
    }

    public void setContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
            return;
        }
        ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
        containerDefinitionsCopy.addAll(containerDefinitions);
        this.containerDefinitions = containerDefinitionsCopy;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(ContainerDefinition ... containerDefinitions) {
        if (this.getContainerDefinitions() == null) {
            this.setContainerDefinitions(new ArrayList<ContainerDefinition>(containerDefinitions.length));
        }
        for (ContainerDefinition value : containerDefinitions) {
            this.getContainerDefinitions().add(value);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withContainerDefinitions(Collection<ContainerDefinition> containerDefinitions) {
        if (containerDefinitions == null) {
            this.containerDefinitions = null;
        } else {
            ListWithAutoConstructFlag containerDefinitionsCopy = new ListWithAutoConstructFlag(containerDefinitions.size());
            containerDefinitionsCopy.addAll(containerDefinitions);
            this.containerDefinitions = containerDefinitionsCopy;
        }
        return this;
    }

    public List<Volume> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new ListWithAutoConstructFlag();
            this.volumes.setAutoConstruct(true);
        }
        return this.volumes;
    }

    public void setVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
        volumesCopy.addAll(volumes);
        this.volumes = volumesCopy;
    }

    public RegisterTaskDefinitionRequest withVolumes(Volume ... volumes) {
        if (this.getVolumes() == null) {
            this.setVolumes(new ArrayList<Volume>(volumes.length));
        }
        for (Volume value : volumes) {
            this.getVolumes().add(value);
        }
        return this;
    }

    public RegisterTaskDefinitionRequest withVolumes(Collection<Volume> volumes) {
        if (volumes == null) {
            this.volumes = null;
        } else {
            ListWithAutoConstructFlag volumesCopy = new ListWithAutoConstructFlag(volumes.size());
            volumesCopy.addAll(volumes);
            this.volumes = volumesCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getFamily() != null) {
            sb.append("Family: " + this.getFamily() + ",");
        }
        if (this.getContainerDefinitions() != null) {
            sb.append("ContainerDefinitions: " + this.getContainerDefinitions() + ",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: " + this.getVolumes());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getFamily() == null ? 0 : this.getFamily().hashCode());
        hashCode = 31 * hashCode + (this.getContainerDefinitions() == null ? 0 : this.getContainerDefinitions().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RegisterTaskDefinitionRequest)) {
            return false;
        }
        RegisterTaskDefinitionRequest other = (RegisterTaskDefinitionRequest)obj;
        if (other.getFamily() == null ^ this.getFamily() == null) {
            return false;
        }
        if (other.getFamily() != null && !other.getFamily().equals(this.getFamily())) {
            return false;
        }
        if (other.getContainerDefinitions() == null ^ this.getContainerDefinitions() == null) {
            return false;
        }
        if (other.getContainerDefinitions() != null && !other.getContainerDefinitions().equals(this.getContainerDefinitions())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        return other.getVolumes() == null || other.getVolumes().equals(this.getVolumes());
    }

    public RegisterTaskDefinitionRequest clone() {
        return (RegisterTaskDefinitionRequest)super.clone();
    }
}

