/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.services.ecs.model.PortMapping;
import com.amazonaws.util.json.JSONWriter;

public class PortMappingJsonMarshaller {
    private static PortMappingJsonMarshaller instance;

    public void marshall(PortMapping portMapping, JSONWriter jsonWriter) {
        if (portMapping == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        try {
            jsonWriter.object();
            if (portMapping.getContainerPort() != null) {
                jsonWriter.key("containerPort").value((Object)portMapping.getContainerPort());
            }
            if (portMapping.getHostPort() != null) {
                jsonWriter.key("hostPort").value((Object)portMapping.getHostPort());
            }
            if (portMapping.getProtocol() != null) {
                jsonWriter.key("protocol").value((Object)portMapping.getProtocol());
            }
            jsonWriter.endObject();
        }
        catch (Throwable t) {
            throw new AmazonClientException("Unable to marshall request to JSON: " + t.getMessage(), t);
        }
    }

    public static PortMappingJsonMarshaller getInstance() {
        if (instance == null) {
            instance = new PortMappingJsonMarshaller();
        }
        return instance;
    }
}

