/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecs.model;

import com.amazonaws.services.ecs.model.LogDriver;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;

public class LogConfiguration
implements Serializable,
Cloneable {
    private String logDriver;
    private Map<String, String> options;

    public String getLogDriver() {
        return this.logDriver;
    }

    public void setLogDriver(String logDriver) {
        this.logDriver = logDriver;
    }

    public LogConfiguration withLogDriver(String logDriver) {
        this.logDriver = logDriver;
        return this;
    }

    public void setLogDriver(LogDriver logDriver) {
        this.logDriver = logDriver.toString();
    }

    public LogConfiguration withLogDriver(LogDriver logDriver) {
        this.logDriver = logDriver.toString();
        return this;
    }

    public Map<String, String> getOptions() {
        if (this.options == null) {
            this.options = new HashMap<String, String>();
        }
        return this.options;
    }

    public void setOptions(Map<String, String> options) {
        this.options = options;
    }

    public LogConfiguration withOptions(Map<String, String> options) {
        this.setOptions(options);
        return this;
    }

    public LogConfiguration addOptionsEntry(String key, String value) {
        if (null == this.options) {
            this.options = new HashMap<String, String>();
        }
        if (this.options.containsKey(key)) {
            throw new IllegalArgumentException("Duplicated keys (" + key.toString() + ") are provided.");
        }
        this.options.put(key, value);
        return this;
    }

    public LogConfiguration clearOptionsEntries() {
        this.options = null;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLogDriver() != null) {
            sb.append("LogDriver: " + this.getLogDriver() + ",");
        }
        if (this.getOptions() != null) {
            sb.append("Options: " + this.getOptions());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLogDriver() == null ? 0 : this.getLogDriver().hashCode());
        hashCode = 31 * hashCode + (this.getOptions() == null ? 0 : this.getOptions().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogConfiguration)) {
            return false;
        }
        LogConfiguration other = (LogConfiguration)obj;
        if (other.getLogDriver() == null ^ this.getLogDriver() == null) {
            return false;
        }
        if (other.getLogDriver() != null && !other.getLogDriver().equals(this.getLogDriver())) {
            return false;
        }
        if (other.getOptions() == null ^ this.getOptions() == null) {
            return false;
        }
        return other.getOptions() == null || other.getOptions().equals(this.getOptions());
    }

    public LogConfiguration clone() {
        try {
            return (LogConfiguration)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

