/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecrpublic.model;

import com.amazonaws.AmazonWebServiceResult;
import com.amazonaws.ResponseMetadata;
import com.amazonaws.services.ecrpublic.model.Layer;
import com.amazonaws.services.ecrpublic.model.LayerFailure;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BatchCheckLayerAvailabilityResult
extends AmazonWebServiceResult<ResponseMetadata>
implements Serializable,
Cloneable {
    private List<Layer> layers;
    private List<LayerFailure> failures;

    public List<Layer> getLayers() {
        return this.layers;
    }

    public void setLayers(Collection<Layer> layers) {
        if (layers == null) {
            this.layers = null;
            return;
        }
        this.layers = new ArrayList<Layer>(layers);
    }

    public BatchCheckLayerAvailabilityResult withLayers(Layer ... layers) {
        if (this.layers == null) {
            this.setLayers(new ArrayList<Layer>(layers.length));
        }
        for (Layer ele : layers) {
            this.layers.add(ele);
        }
        return this;
    }

    public BatchCheckLayerAvailabilityResult withLayers(Collection<Layer> layers) {
        this.setLayers(layers);
        return this;
    }

    public List<LayerFailure> getFailures() {
        return this.failures;
    }

    public void setFailures(Collection<LayerFailure> failures) {
        if (failures == null) {
            this.failures = null;
            return;
        }
        this.failures = new ArrayList<LayerFailure>(failures);
    }

    public BatchCheckLayerAvailabilityResult withFailures(LayerFailure ... failures) {
        if (this.failures == null) {
            this.setFailures(new ArrayList<LayerFailure>(failures.length));
        }
        for (LayerFailure ele : failures) {
            this.failures.add(ele);
        }
        return this;
    }

    public BatchCheckLayerAvailabilityResult withFailures(Collection<LayerFailure> failures) {
        this.setFailures(failures);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getLayers() != null) {
            sb.append("Layers: ").append(this.getLayers()).append(",");
        }
        if (this.getFailures() != null) {
            sb.append("Failures: ").append(this.getFailures());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchCheckLayerAvailabilityResult)) {
            return false;
        }
        BatchCheckLayerAvailabilityResult other = (BatchCheckLayerAvailabilityResult)obj;
        if (other.getLayers() == null ^ this.getLayers() == null) {
            return false;
        }
        if (other.getLayers() != null && !other.getLayers().equals(this.getLayers())) {
            return false;
        }
        if (other.getFailures() == null ^ this.getFailures() == null) {
            return false;
        }
        return other.getFailures() == null || other.getFailures().equals(this.getFailures());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getLayers() == null ? 0 : this.getLayers().hashCode());
        hashCode = 31 * hashCode + (this.getFailures() == null ? 0 : this.getFailures().hashCode());
        return hashCode;
    }

    public BatchCheckLayerAvailabilityResult clone() {
        try {
            return (BatchCheckLayerAvailabilityResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

