/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.CvssScoreAdjustment;
import com.amazonaws.services.ecr.model.transform.CvssScoreDetailsMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CvssScoreDetails
implements Serializable,
Cloneable,
StructuredPojo {
    private List<CvssScoreAdjustment> adjustments;
    private Double score;
    private String scoreSource;
    private String scoringVector;
    private String version;

    public List<CvssScoreAdjustment> getAdjustments() {
        return this.adjustments;
    }

    public void setAdjustments(Collection<CvssScoreAdjustment> adjustments) {
        if (adjustments == null) {
            this.adjustments = null;
            return;
        }
        this.adjustments = new ArrayList<CvssScoreAdjustment>(adjustments);
    }

    public CvssScoreDetails withAdjustments(CvssScoreAdjustment ... adjustments) {
        if (this.adjustments == null) {
            this.setAdjustments(new ArrayList<CvssScoreAdjustment>(adjustments.length));
        }
        for (CvssScoreAdjustment ele : adjustments) {
            this.adjustments.add(ele);
        }
        return this;
    }

    public CvssScoreDetails withAdjustments(Collection<CvssScoreAdjustment> adjustments) {
        this.setAdjustments(adjustments);
        return this;
    }

    public void setScore(Double score) {
        this.score = score;
    }

    public Double getScore() {
        return this.score;
    }

    public CvssScoreDetails withScore(Double score) {
        this.setScore(score);
        return this;
    }

    public void setScoreSource(String scoreSource) {
        this.scoreSource = scoreSource;
    }

    public String getScoreSource() {
        return this.scoreSource;
    }

    public CvssScoreDetails withScoreSource(String scoreSource) {
        this.setScoreSource(scoreSource);
        return this;
    }

    public void setScoringVector(String scoringVector) {
        this.scoringVector = scoringVector;
    }

    public String getScoringVector() {
        return this.scoringVector;
    }

    public CvssScoreDetails withScoringVector(String scoringVector) {
        this.setScoringVector(scoringVector);
        return this;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getVersion() {
        return this.version;
    }

    public CvssScoreDetails withVersion(String version) {
        this.setVersion(version);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAdjustments() != null) {
            sb.append("Adjustments: ").append(this.getAdjustments()).append(",");
        }
        if (this.getScore() != null) {
            sb.append("Score: ").append(this.getScore()).append(",");
        }
        if (this.getScoreSource() != null) {
            sb.append("ScoreSource: ").append(this.getScoreSource()).append(",");
        }
        if (this.getScoringVector() != null) {
            sb.append("ScoringVector: ").append(this.getScoringVector()).append(",");
        }
        if (this.getVersion() != null) {
            sb.append("Version: ").append(this.getVersion());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CvssScoreDetails)) {
            return false;
        }
        CvssScoreDetails other = (CvssScoreDetails)obj;
        if (other.getAdjustments() == null ^ this.getAdjustments() == null) {
            return false;
        }
        if (other.getAdjustments() != null && !other.getAdjustments().equals(this.getAdjustments())) {
            return false;
        }
        if (other.getScore() == null ^ this.getScore() == null) {
            return false;
        }
        if (other.getScore() != null && !other.getScore().equals(this.getScore())) {
            return false;
        }
        if (other.getScoreSource() == null ^ this.getScoreSource() == null) {
            return false;
        }
        if (other.getScoreSource() != null && !other.getScoreSource().equals(this.getScoreSource())) {
            return false;
        }
        if (other.getScoringVector() == null ^ this.getScoringVector() == null) {
            return false;
        }
        if (other.getScoringVector() != null && !other.getScoringVector().equals(this.getScoringVector())) {
            return false;
        }
        if (other.getVersion() == null ^ this.getVersion() == null) {
            return false;
        }
        return other.getVersion() == null || other.getVersion().equals(this.getVersion());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAdjustments() == null ? 0 : this.getAdjustments().hashCode());
        hashCode = 31 * hashCode + (this.getScore() == null ? 0 : this.getScore().hashCode());
        hashCode = 31 * hashCode + (this.getScoreSource() == null ? 0 : this.getScoreSource().hashCode());
        hashCode = 31 * hashCode + (this.getScoringVector() == null ? 0 : this.getScoringVector().hashCode());
        hashCode = 31 * hashCode + (this.getVersion() == null ? 0 : this.getVersion().hashCode());
        return hashCode;
    }

    public CvssScoreDetails clone() {
        try {
            return (CvssScoreDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        CvssScoreDetailsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

