/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr.model;

import com.amazonaws.annotation.SdkInternalApi;
import com.amazonaws.protocol.ProtocolMarshaller;
import com.amazonaws.protocol.StructuredPojo;
import com.amazonaws.services.ecr.model.ReplicationDestination;
import com.amazonaws.services.ecr.model.transform.ReplicationRuleMarshaller;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ReplicationRule
implements Serializable,
Cloneable,
StructuredPojo {
    private List<ReplicationDestination> destinations;

    public List<ReplicationDestination> getDestinations() {
        return this.destinations;
    }

    public void setDestinations(Collection<ReplicationDestination> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new ArrayList<ReplicationDestination>(destinations);
    }

    public ReplicationRule withDestinations(ReplicationDestination ... destinations) {
        if (this.destinations == null) {
            this.setDestinations(new ArrayList<ReplicationDestination>(destinations.length));
        }
        for (ReplicationDestination ele : destinations) {
            this.destinations.add(ele);
        }
        return this;
    }

    public ReplicationRule withDestinations(Collection<ReplicationDestination> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReplicationRule)) {
            return false;
        }
        ReplicationRule other = (ReplicationRule)obj;
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        return other.getDestinations() == null || other.getDestinations().equals(this.getDestinations());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        return hashCode;
    }

    public ReplicationRule clone() {
        try {
            return (ReplicationRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        ReplicationRuleMarshaller.getInstance().marshall(this, protocolMarshaller);
    }
}

