/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ecr;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.PredefinedClientConfigurations;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.DefaultAWSCredentialsProviderChain;
import com.amazonaws.handlers.AsyncHandler;
import com.amazonaws.services.ecr.AmazonECRAsync;
import com.amazonaws.services.ecr.AmazonECRClient;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityRequest;
import com.amazonaws.services.ecr.model.BatchCheckLayerAvailabilityResult;
import com.amazonaws.services.ecr.model.BatchDeleteImageRequest;
import com.amazonaws.services.ecr.model.BatchDeleteImageResult;
import com.amazonaws.services.ecr.model.BatchGetImageRequest;
import com.amazonaws.services.ecr.model.BatchGetImageResult;
import com.amazonaws.services.ecr.model.CompleteLayerUploadRequest;
import com.amazonaws.services.ecr.model.CompleteLayerUploadResult;
import com.amazonaws.services.ecr.model.CreateRepositoryRequest;
import com.amazonaws.services.ecr.model.CreateRepositoryResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.DeleteRepositoryRequest;
import com.amazonaws.services.ecr.model.DeleteRepositoryResult;
import com.amazonaws.services.ecr.model.DescribeRepositoriesRequest;
import com.amazonaws.services.ecr.model.DescribeRepositoriesResult;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenRequest;
import com.amazonaws.services.ecr.model.GetAuthorizationTokenResult;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerRequest;
import com.amazonaws.services.ecr.model.GetDownloadUrlForLayerResult;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.GetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.InitiateLayerUploadRequest;
import com.amazonaws.services.ecr.model.InitiateLayerUploadResult;
import com.amazonaws.services.ecr.model.ListImagesRequest;
import com.amazonaws.services.ecr.model.ListImagesResult;
import com.amazonaws.services.ecr.model.PutImageRequest;
import com.amazonaws.services.ecr.model.PutImageResult;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyRequest;
import com.amazonaws.services.ecr.model.SetRepositoryPolicyResult;
import com.amazonaws.services.ecr.model.UploadLayerPartRequest;
import com.amazonaws.services.ecr.model.UploadLayerPartResult;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;

public class AmazonECRAsyncClient
extends AmazonECRClient
implements AmazonECRAsync {
    private static final int DEFAULT_THREAD_POOL_SIZE = 50;
    private final ExecutorService executorService;

    public AmazonECRAsyncClient() {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain());
    }

    public AmazonECRAsyncClient(ClientConfiguration clientConfiguration) {
        this((AWSCredentialsProvider)new DefaultAWSCredentialsProviderChain(), clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECRAsyncClient(AWSCredentials awsCredentials) {
        this(awsCredentials, Executors.newFixedThreadPool(50));
    }

    public AmazonECRAsyncClient(AWSCredentials awsCredentials, ExecutorService executorService) {
        this(awsCredentials, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonECRAsyncClient(AWSCredentials awsCredentials, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentials, clientConfiguration);
        this.executorService = executorService;
    }

    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider) {
        this(awsCredentialsProvider, Executors.newFixedThreadPool(50));
    }

    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration) {
        this(awsCredentialsProvider, clientConfiguration, Executors.newFixedThreadPool(clientConfiguration.getMaxConnections()));
    }

    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ExecutorService executorService) {
        this(awsCredentialsProvider, PredefinedClientConfigurations.defaultConfig(), executorService);
    }

    public AmazonECRAsyncClient(AWSCredentialsProvider awsCredentialsProvider, ClientConfiguration clientConfiguration, ExecutorService executorService) {
        super(awsCredentialsProvider, clientConfiguration);
        this.executorService = executorService;
    }

    public ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(BatchCheckLayerAvailabilityRequest request) {
        return this.batchCheckLayerAvailabilityAsync(request, null);
    }

    @Override
    public Future<BatchCheckLayerAvailabilityResult> batchCheckLayerAvailabilityAsync(final BatchCheckLayerAvailabilityRequest request, final AsyncHandler<BatchCheckLayerAvailabilityRequest, BatchCheckLayerAvailabilityResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchCheckLayerAvailabilityResult>(){

            @Override
            public BatchCheckLayerAvailabilityResult call() throws Exception {
                BatchCheckLayerAvailabilityResult result;
                try {
                    result = AmazonECRAsyncClient.this.batchCheckLayerAvailability(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(BatchDeleteImageRequest request) {
        return this.batchDeleteImageAsync(request, null);
    }

    @Override
    public Future<BatchDeleteImageResult> batchDeleteImageAsync(final BatchDeleteImageRequest request, final AsyncHandler<BatchDeleteImageRequest, BatchDeleteImageResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchDeleteImageResult>(){

            @Override
            public BatchDeleteImageResult call() throws Exception {
                BatchDeleteImageResult result;
                try {
                    result = AmazonECRAsyncClient.this.batchDeleteImage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<BatchGetImageResult> batchGetImageAsync(BatchGetImageRequest request) {
        return this.batchGetImageAsync(request, null);
    }

    @Override
    public Future<BatchGetImageResult> batchGetImageAsync(final BatchGetImageRequest request, final AsyncHandler<BatchGetImageRequest, BatchGetImageResult> asyncHandler) {
        return this.executorService.submit(new Callable<BatchGetImageResult>(){

            @Override
            public BatchGetImageResult call() throws Exception {
                BatchGetImageResult result;
                try {
                    result = AmazonECRAsyncClient.this.batchGetImage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(CompleteLayerUploadRequest request) {
        return this.completeLayerUploadAsync(request, null);
    }

    @Override
    public Future<CompleteLayerUploadResult> completeLayerUploadAsync(final CompleteLayerUploadRequest request, final AsyncHandler<CompleteLayerUploadRequest, CompleteLayerUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<CompleteLayerUploadResult>(){

            @Override
            public CompleteLayerUploadResult call() throws Exception {
                CompleteLayerUploadResult result;
                try {
                    result = AmazonECRAsyncClient.this.completeLayerUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(CreateRepositoryRequest request) {
        return this.createRepositoryAsync(request, null);
    }

    @Override
    public Future<CreateRepositoryResult> createRepositoryAsync(final CreateRepositoryRequest request, final AsyncHandler<CreateRepositoryRequest, CreateRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<CreateRepositoryResult>(){

            @Override
            public CreateRepositoryResult call() throws Exception {
                CreateRepositoryResult result;
                try {
                    result = AmazonECRAsyncClient.this.createRepository(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(DeleteRepositoryRequest request) {
        return this.deleteRepositoryAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryResult> deleteRepositoryAsync(final DeleteRepositoryRequest request, final AsyncHandler<DeleteRepositoryRequest, DeleteRepositoryResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRepositoryResult>(){

            @Override
            public DeleteRepositoryResult call() throws Exception {
                DeleteRepositoryResult result;
                try {
                    result = AmazonECRAsyncClient.this.deleteRepository(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(DeleteRepositoryPolicyRequest request) {
        return this.deleteRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<DeleteRepositoryPolicyResult> deleteRepositoryPolicyAsync(final DeleteRepositoryPolicyRequest request, final AsyncHandler<DeleteRepositoryPolicyRequest, DeleteRepositoryPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<DeleteRepositoryPolicyResult>(){

            @Override
            public DeleteRepositoryPolicyResult call() throws Exception {
                DeleteRepositoryPolicyResult result;
                try {
                    result = AmazonECRAsyncClient.this.deleteRepositoryPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(DescribeRepositoriesRequest request) {
        return this.describeRepositoriesAsync(request, null);
    }

    @Override
    public Future<DescribeRepositoriesResult> describeRepositoriesAsync(final DescribeRepositoriesRequest request, final AsyncHandler<DescribeRepositoriesRequest, DescribeRepositoriesResult> asyncHandler) {
        return this.executorService.submit(new Callable<DescribeRepositoriesResult>(){

            @Override
            public DescribeRepositoriesResult call() throws Exception {
                DescribeRepositoriesResult result;
                try {
                    result = AmazonECRAsyncClient.this.describeRepositories(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(GetAuthorizationTokenRequest request) {
        return this.getAuthorizationTokenAsync(request, null);
    }

    @Override
    public Future<GetAuthorizationTokenResult> getAuthorizationTokenAsync(final GetAuthorizationTokenRequest request, final AsyncHandler<GetAuthorizationTokenRequest, GetAuthorizationTokenResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetAuthorizationTokenResult>(){

            @Override
            public GetAuthorizationTokenResult call() throws Exception {
                GetAuthorizationTokenResult result;
                try {
                    result = AmazonECRAsyncClient.this.getAuthorizationToken(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetDownloadUrlForLayerResult> getDownloadUrlForLayerAsync(GetDownloadUrlForLayerRequest request) {
        return this.getDownloadUrlForLayerAsync(request, null);
    }

    @Override
    public Future<GetDownloadUrlForLayerResult> getDownloadUrlForLayerAsync(final GetDownloadUrlForLayerRequest request, final AsyncHandler<GetDownloadUrlForLayerRequest, GetDownloadUrlForLayerResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetDownloadUrlForLayerResult>(){

            @Override
            public GetDownloadUrlForLayerResult call() throws Exception {
                GetDownloadUrlForLayerResult result;
                try {
                    result = AmazonECRAsyncClient.this.getDownloadUrlForLayer(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(GetRepositoryPolicyRequest request) {
        return this.getRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<GetRepositoryPolicyResult> getRepositoryPolicyAsync(final GetRepositoryPolicyRequest request, final AsyncHandler<GetRepositoryPolicyRequest, GetRepositoryPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<GetRepositoryPolicyResult>(){

            @Override
            public GetRepositoryPolicyResult call() throws Exception {
                GetRepositoryPolicyResult result;
                try {
                    result = AmazonECRAsyncClient.this.getRepositoryPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(InitiateLayerUploadRequest request) {
        return this.initiateLayerUploadAsync(request, null);
    }

    @Override
    public Future<InitiateLayerUploadResult> initiateLayerUploadAsync(final InitiateLayerUploadRequest request, final AsyncHandler<InitiateLayerUploadRequest, InitiateLayerUploadResult> asyncHandler) {
        return this.executorService.submit(new Callable<InitiateLayerUploadResult>(){

            @Override
            public InitiateLayerUploadResult call() throws Exception {
                InitiateLayerUploadResult result;
                try {
                    result = AmazonECRAsyncClient.this.initiateLayerUpload(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<ListImagesResult> listImagesAsync(ListImagesRequest request) {
        return this.listImagesAsync(request, null);
    }

    @Override
    public Future<ListImagesResult> listImagesAsync(final ListImagesRequest request, final AsyncHandler<ListImagesRequest, ListImagesResult> asyncHandler) {
        return this.executorService.submit(new Callable<ListImagesResult>(){

            @Override
            public ListImagesResult call() throws Exception {
                ListImagesResult result;
                try {
                    result = AmazonECRAsyncClient.this.listImages(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<PutImageResult> putImageAsync(PutImageRequest request) {
        return this.putImageAsync(request, null);
    }

    @Override
    public Future<PutImageResult> putImageAsync(final PutImageRequest request, final AsyncHandler<PutImageRequest, PutImageResult> asyncHandler) {
        return this.executorService.submit(new Callable<PutImageResult>(){

            @Override
            public PutImageResult call() throws Exception {
                PutImageResult result;
                try {
                    result = AmazonECRAsyncClient.this.putImage(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(SetRepositoryPolicyRequest request) {
        return this.setRepositoryPolicyAsync(request, null);
    }

    @Override
    public Future<SetRepositoryPolicyResult> setRepositoryPolicyAsync(final SetRepositoryPolicyRequest request, final AsyncHandler<SetRepositoryPolicyRequest, SetRepositoryPolicyResult> asyncHandler) {
        return this.executorService.submit(new Callable<SetRepositoryPolicyResult>(){

            @Override
            public SetRepositoryPolicyResult call() throws Exception {
                SetRepositoryPolicyResult result;
                try {
                    result = AmazonECRAsyncClient.this.setRepositoryPolicy(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(UploadLayerPartRequest request) {
        return this.uploadLayerPartAsync(request, null);
    }

    @Override
    public Future<UploadLayerPartResult> uploadLayerPartAsync(final UploadLayerPartRequest request, final AsyncHandler<UploadLayerPartRequest, UploadLayerPartResult> asyncHandler) {
        return this.executorService.submit(new Callable<UploadLayerPartResult>(){

            @Override
            public UploadLayerPartResult call() throws Exception {
                UploadLayerPartResult result;
                try {
                    result = AmazonECRAsyncClient.this.uploadLayerPart(request);
                }
                catch (Exception ex) {
                    if (asyncHandler != null) {
                        asyncHandler.onError(ex);
                    }
                    throw ex;
                }
                if (asyncHandler != null) {
                    asyncHandler.onSuccess((AmazonWebServiceRequest)request, (Object)result);
                }
                return result;
            }
        });
    }

    @Override
    public void shutdown() {
        super.shutdown();
        this.executorService.shutdownNow();
    }
}

