/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.IcmpTypeCode;
import com.amazonaws.services.ec2.model.PortRange;
import com.amazonaws.services.ec2.model.ReplaceNetworkAclEntryRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReplaceNetworkAclEntryRequestMarshaller
implements Marshaller<Request<ReplaceNetworkAclEntryRequest>, ReplaceNetworkAclEntryRequest> {
    public Request<ReplaceNetworkAclEntryRequest> marshall(ReplaceNetworkAclEntryRequest replaceNetworkAclEntryRequest) {
        PortRange portRangePortRange;
        IcmpTypeCode icmpTypeCodeIcmpTypeCode;
        if (replaceNetworkAclEntryRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)replaceNetworkAclEntryRequest, "AmazonEC2");
        request.addParameter("Action", "ReplaceNetworkAclEntry");
        request.addParameter("Version", "2014-10-01");
        if (replaceNetworkAclEntryRequest.getNetworkAclId() != null) {
            request.addParameter("NetworkAclId", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getNetworkAclId()));
        }
        if (replaceNetworkAclEntryRequest.getRuleNumber() != null) {
            request.addParameter("RuleNumber", StringUtils.fromInteger((Integer)replaceNetworkAclEntryRequest.getRuleNumber()));
        }
        if (replaceNetworkAclEntryRequest.getProtocol() != null) {
            request.addParameter("Protocol", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getProtocol()));
        }
        if (replaceNetworkAclEntryRequest.getRuleAction() != null) {
            request.addParameter("RuleAction", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getRuleAction()));
        }
        if (replaceNetworkAclEntryRequest.isEgress() != null) {
            request.addParameter("Egress", StringUtils.fromBoolean((Boolean)replaceNetworkAclEntryRequest.isEgress()));
        }
        if (replaceNetworkAclEntryRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)replaceNetworkAclEntryRequest.getCidrBlock()));
        }
        if ((icmpTypeCodeIcmpTypeCode = replaceNetworkAclEntryRequest.getIcmpTypeCode()) != null) {
            if (icmpTypeCodeIcmpTypeCode.getType() != null) {
                request.addParameter("Icmp.Type", StringUtils.fromInteger((Integer)icmpTypeCodeIcmpTypeCode.getType()));
            }
            if (icmpTypeCodeIcmpTypeCode.getCode() != null) {
                request.addParameter("Icmp.Code", StringUtils.fromInteger((Integer)icmpTypeCodeIcmpTypeCode.getCode()));
            }
        }
        if ((portRangePortRange = replaceNetworkAclEntryRequest.getPortRange()) != null) {
            if (portRangePortRange.getFrom() != null) {
                request.addParameter("PortRange.From", StringUtils.fromInteger((Integer)portRangePortRange.getFrom()));
            }
            if (portRangePortRange.getTo() != null) {
                request.addParameter("PortRange.To", StringUtils.fromInteger((Integer)portRangePortRange.getTo()));
            }
        }
        return request;
    }
}

