/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.CreateVolumePermission;
import com.amazonaws.services.ec2.model.CreateVolumePermissionModifications;
import com.amazonaws.services.ec2.model.ModifySnapshotAttributeRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.List;

public class ModifySnapshotAttributeRequestMarshaller
implements Marshaller<Request<ModifySnapshotAttributeRequest>, ModifySnapshotAttributeRequest> {
    public Request<ModifySnapshotAttributeRequest> marshall(ModifySnapshotAttributeRequest modifySnapshotAttributeRequest) {
        if (modifySnapshotAttributeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifySnapshotAttributeRequest, "AmazonEC2");
        request.addParameter("Action", "ModifySnapshotAttribute");
        request.addParameter("Version", "2014-10-01");
        if (modifySnapshotAttributeRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)modifySnapshotAttributeRequest.getSnapshotId()));
        }
        if (modifySnapshotAttributeRequest.getAttribute() != null) {
            request.addParameter("Attribute", StringUtils.fromString((String)modifySnapshotAttributeRequest.getAttribute()));
        }
        if (modifySnapshotAttributeRequest.getOperationType() != null) {
            request.addParameter("OperationType", StringUtils.fromString((String)modifySnapshotAttributeRequest.getOperationType()));
        }
        List<String> userIdsList = modifySnapshotAttributeRequest.getUserIds();
        int userIdsListIndex = 1;
        for (String userIdsListValue : userIdsList) {
            if (userIdsListValue != null) {
                request.addParameter("UserId." + userIdsListIndex, StringUtils.fromString((String)userIdsListValue));
            }
            ++userIdsListIndex;
        }
        List<String> groupNamesList = modifySnapshotAttributeRequest.getGroupNames();
        int groupNamesListIndex = 1;
        for (String groupNamesListValue : groupNamesList) {
            if (groupNamesListValue != null) {
                request.addParameter("UserGroup." + groupNamesListIndex, StringUtils.fromString((String)groupNamesListValue));
            }
            ++groupNamesListIndex;
        }
        CreateVolumePermissionModifications createVolumePermissionModificationsCreateVolumePermission = modifySnapshotAttributeRequest.getCreateVolumePermission();
        if (createVolumePermissionModificationsCreateVolumePermission != null) {
            List<CreateVolumePermission> addList = createVolumePermissionModificationsCreateVolumePermission.getAdd();
            int addListIndex = 1;
            for (CreateVolumePermission addListValue : addList) {
                CreateVolumePermission createVolumePermissionMember = addListValue;
                if (createVolumePermissionMember != null) {
                    if (createVolumePermissionMember.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionMember.getUserId()));
                    }
                    if (createVolumePermissionMember.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Add." + addListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionMember.getGroup()));
                    }
                }
                ++addListIndex;
            }
            List<CreateVolumePermission> removeList = createVolumePermissionModificationsCreateVolumePermission.getRemove();
            int removeListIndex = 1;
            for (CreateVolumePermission removeListValue : removeList) {
                CreateVolumePermission createVolumePermissionMember = removeListValue;
                if (createVolumePermissionMember != null) {
                    if (createVolumePermissionMember.getUserId() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".UserId", StringUtils.fromString((String)createVolumePermissionMember.getUserId()));
                    }
                    if (createVolumePermissionMember.getGroup() != null) {
                        request.addParameter("CreateVolumePermission.Remove." + removeListIndex + ".Group", StringUtils.fromString((String)createVolumePermissionMember.getGroup()));
                    }
                }
                ++removeListIndex;
            }
        }
        return request;
    }
}

