/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateInstanceEventWindowRequest;
import com.amazonaws.services.ec2.model.InstanceEventWindowTimeRangeRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateInstanceEventWindowRequestMarshaller
implements Marshaller<Request<CreateInstanceEventWindowRequest>, CreateInstanceEventWindowRequest> {
    public Request<CreateInstanceEventWindowRequest> marshall(CreateInstanceEventWindowRequest createInstanceEventWindowRequest) {
        SdkInternalList createInstanceEventWindowRequestTagSpecificationsList;
        SdkInternalList createInstanceEventWindowRequestTimeRangesList;
        if (createInstanceEventWindowRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createInstanceEventWindowRequest, "AmazonEC2");
        request.addParameter("Action", "CreateInstanceEventWindow");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createInstanceEventWindowRequest.getName() != null) {
            request.addParameter("Name", StringUtils.fromString((String)createInstanceEventWindowRequest.getName()));
        }
        if (!(createInstanceEventWindowRequestTimeRangesList = (SdkInternalList)createInstanceEventWindowRequest.getTimeRanges()).isEmpty() || !createInstanceEventWindowRequestTimeRangesList.isAutoConstruct()) {
            int timeRangesListIndex = 1;
            for (InstanceEventWindowTimeRangeRequest createInstanceEventWindowRequestTimeRangesListValue : createInstanceEventWindowRequestTimeRangesList) {
                if (createInstanceEventWindowRequestTimeRangesListValue.getStartWeekDay() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".StartWeekDay", StringUtils.fromString((String)createInstanceEventWindowRequestTimeRangesListValue.getStartWeekDay()));
                }
                if (createInstanceEventWindowRequestTimeRangesListValue.getStartHour() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".StartHour", StringUtils.fromInteger((Integer)createInstanceEventWindowRequestTimeRangesListValue.getStartHour()));
                }
                if (createInstanceEventWindowRequestTimeRangesListValue.getEndWeekDay() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".EndWeekDay", StringUtils.fromString((String)createInstanceEventWindowRequestTimeRangesListValue.getEndWeekDay()));
                }
                if (createInstanceEventWindowRequestTimeRangesListValue.getEndHour() != null) {
                    request.addParameter("TimeRange." + timeRangesListIndex + ".EndHour", StringUtils.fromInteger((Integer)createInstanceEventWindowRequestTimeRangesListValue.getEndHour()));
                }
                ++timeRangesListIndex;
            }
        }
        if (createInstanceEventWindowRequest.getCronExpression() != null) {
            request.addParameter("CronExpression", StringUtils.fromString((String)createInstanceEventWindowRequest.getCronExpression()));
        }
        if (!(createInstanceEventWindowRequestTagSpecificationsList = (SdkInternalList)createInstanceEventWindowRequest.getTagSpecifications()).isEmpty() || !createInstanceEventWindowRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createInstanceEventWindowRequestTagSpecificationsListValue : createInstanceEventWindowRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createInstanceEventWindowRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createInstanceEventWindowRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createInstanceEventWindowRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        return request;
    }
}

