/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.SubnetConfiguration;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import javax.xml.stream.events.XMLEvent;

public class SubnetConfigurationStaxUnmarshaller
implements Unmarshaller<SubnetConfiguration, StaxUnmarshallerContext> {
    private static SubnetConfigurationStaxUnmarshaller instance;

    public SubnetConfiguration unmarshall(StaxUnmarshallerContext context) throws Exception {
        SubnetConfiguration subnetConfiguration = new SubnetConfiguration();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return subnetConfiguration;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("SubnetId", targetDepth)) {
                    subnetConfiguration.setSubnetId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("Ipv4", targetDepth)) {
                    subnetConfiguration.setIpv4(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("Ipv6", targetDepth)) continue;
                subnetConfiguration.setIpv6(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return subnetConfiguration;
    }

    public static SubnetConfigurationStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new SubnetConfigurationStaxUnmarshaller();
        }
        return instance;
    }
}

