/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.LockSnapshotRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;
import java.util.Date;

public class LockSnapshotRequestMarshaller
implements Marshaller<Request<LockSnapshotRequest>, LockSnapshotRequest> {
    public Request<LockSnapshotRequest> marshall(LockSnapshotRequest lockSnapshotRequest) {
        if (lockSnapshotRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)lockSnapshotRequest, "AmazonEC2");
        request.addParameter("Action", "LockSnapshot");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (lockSnapshotRequest.getSnapshotId() != null) {
            request.addParameter("SnapshotId", StringUtils.fromString((String)lockSnapshotRequest.getSnapshotId()));
        }
        if (lockSnapshotRequest.getLockMode() != null) {
            request.addParameter("LockMode", StringUtils.fromString((String)lockSnapshotRequest.getLockMode()));
        }
        if (lockSnapshotRequest.getCoolOffPeriod() != null) {
            request.addParameter("CoolOffPeriod", StringUtils.fromInteger((Integer)lockSnapshotRequest.getCoolOffPeriod()));
        }
        if (lockSnapshotRequest.getLockDuration() != null) {
            request.addParameter("LockDuration", StringUtils.fromInteger((Integer)lockSnapshotRequest.getLockDuration()));
        }
        if (lockSnapshotRequest.getExpirationDate() != null) {
            request.addParameter("ExpirationDate", StringUtils.fromDate((Date)lockSnapshotRequest.getExpirationDate()));
        }
        return request;
    }
}

