/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PortRange;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class FirewallStatefulRule
implements Serializable,
Cloneable {
    private String ruleGroupArn;
    private SdkInternalList<String> sources;
    private SdkInternalList<String> destinations;
    private SdkInternalList<PortRange> sourcePorts;
    private SdkInternalList<PortRange> destinationPorts;
    private String protocol;
    private String ruleAction;
    private String direction;

    public void setRuleGroupArn(String ruleGroupArn) {
        this.ruleGroupArn = ruleGroupArn;
    }

    public String getRuleGroupArn() {
        return this.ruleGroupArn;
    }

    public FirewallStatefulRule withRuleGroupArn(String ruleGroupArn) {
        this.setRuleGroupArn(ruleGroupArn);
        return this;
    }

    public List<String> getSources() {
        if (this.sources == null) {
            this.sources = new SdkInternalList();
        }
        return this.sources;
    }

    public void setSources(Collection<String> sources) {
        if (sources == null) {
            this.sources = null;
            return;
        }
        this.sources = new SdkInternalList(sources);
    }

    public FirewallStatefulRule withSources(String ... sources) {
        if (this.sources == null) {
            this.setSources((Collection<String>)new SdkInternalList(sources.length));
        }
        for (String ele : sources) {
            this.sources.add((Object)ele);
        }
        return this;
    }

    public FirewallStatefulRule withSources(Collection<String> sources) {
        this.setSources(sources);
        return this;
    }

    public List<String> getDestinations() {
        if (this.destinations == null) {
            this.destinations = new SdkInternalList();
        }
        return this.destinations;
    }

    public void setDestinations(Collection<String> destinations) {
        if (destinations == null) {
            this.destinations = null;
            return;
        }
        this.destinations = new SdkInternalList(destinations);
    }

    public FirewallStatefulRule withDestinations(String ... destinations) {
        if (this.destinations == null) {
            this.setDestinations((Collection<String>)new SdkInternalList(destinations.length));
        }
        for (String ele : destinations) {
            this.destinations.add((Object)ele);
        }
        return this;
    }

    public FirewallStatefulRule withDestinations(Collection<String> destinations) {
        this.setDestinations(destinations);
        return this;
    }

    public List<PortRange> getSourcePorts() {
        if (this.sourcePorts == null) {
            this.sourcePorts = new SdkInternalList();
        }
        return this.sourcePorts;
    }

    public void setSourcePorts(Collection<PortRange> sourcePorts) {
        if (sourcePorts == null) {
            this.sourcePorts = null;
            return;
        }
        this.sourcePorts = new SdkInternalList(sourcePorts);
    }

    public FirewallStatefulRule withSourcePorts(PortRange ... sourcePorts) {
        if (this.sourcePorts == null) {
            this.setSourcePorts((Collection<PortRange>)new SdkInternalList(sourcePorts.length));
        }
        for (PortRange ele : sourcePorts) {
            this.sourcePorts.add((Object)ele);
        }
        return this;
    }

    public FirewallStatefulRule withSourcePorts(Collection<PortRange> sourcePorts) {
        this.setSourcePorts(sourcePorts);
        return this;
    }

    public List<PortRange> getDestinationPorts() {
        if (this.destinationPorts == null) {
            this.destinationPorts = new SdkInternalList();
        }
        return this.destinationPorts;
    }

    public void setDestinationPorts(Collection<PortRange> destinationPorts) {
        if (destinationPorts == null) {
            this.destinationPorts = null;
            return;
        }
        this.destinationPorts = new SdkInternalList(destinationPorts);
    }

    public FirewallStatefulRule withDestinationPorts(PortRange ... destinationPorts) {
        if (this.destinationPorts == null) {
            this.setDestinationPorts((Collection<PortRange>)new SdkInternalList(destinationPorts.length));
        }
        for (PortRange ele : destinationPorts) {
            this.destinationPorts.add((Object)ele);
        }
        return this;
    }

    public FirewallStatefulRule withDestinationPorts(Collection<PortRange> destinationPorts) {
        this.setDestinationPorts(destinationPorts);
        return this;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public FirewallStatefulRule withProtocol(String protocol) {
        this.setProtocol(protocol);
        return this;
    }

    public void setRuleAction(String ruleAction) {
        this.ruleAction = ruleAction;
    }

    public String getRuleAction() {
        return this.ruleAction;
    }

    public FirewallStatefulRule withRuleAction(String ruleAction) {
        this.setRuleAction(ruleAction);
        return this;
    }

    public void setDirection(String direction) {
        this.direction = direction;
    }

    public String getDirection() {
        return this.direction;
    }

    public FirewallStatefulRule withDirection(String direction) {
        this.setDirection(direction);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getRuleGroupArn() != null) {
            sb.append("RuleGroupArn: ").append(this.getRuleGroupArn()).append(",");
        }
        if (this.getSources() != null) {
            sb.append("Sources: ").append(this.getSources()).append(",");
        }
        if (this.getDestinations() != null) {
            sb.append("Destinations: ").append(this.getDestinations()).append(",");
        }
        if (this.getSourcePorts() != null) {
            sb.append("SourcePorts: ").append(this.getSourcePorts()).append(",");
        }
        if (this.getDestinationPorts() != null) {
            sb.append("DestinationPorts: ").append(this.getDestinationPorts()).append(",");
        }
        if (this.getProtocol() != null) {
            sb.append("Protocol: ").append(this.getProtocol()).append(",");
        }
        if (this.getRuleAction() != null) {
            sb.append("RuleAction: ").append(this.getRuleAction()).append(",");
        }
        if (this.getDirection() != null) {
            sb.append("Direction: ").append(this.getDirection());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FirewallStatefulRule)) {
            return false;
        }
        FirewallStatefulRule other = (FirewallStatefulRule)obj;
        if (other.getRuleGroupArn() == null ^ this.getRuleGroupArn() == null) {
            return false;
        }
        if (other.getRuleGroupArn() != null && !other.getRuleGroupArn().equals(this.getRuleGroupArn())) {
            return false;
        }
        if (other.getSources() == null ^ this.getSources() == null) {
            return false;
        }
        if (other.getSources() != null && !other.getSources().equals(this.getSources())) {
            return false;
        }
        if (other.getDestinations() == null ^ this.getDestinations() == null) {
            return false;
        }
        if (other.getDestinations() != null && !other.getDestinations().equals(this.getDestinations())) {
            return false;
        }
        if (other.getSourcePorts() == null ^ this.getSourcePorts() == null) {
            return false;
        }
        if (other.getSourcePorts() != null && !other.getSourcePorts().equals(this.getSourcePorts())) {
            return false;
        }
        if (other.getDestinationPorts() == null ^ this.getDestinationPorts() == null) {
            return false;
        }
        if (other.getDestinationPorts() != null && !other.getDestinationPorts().equals(this.getDestinationPorts())) {
            return false;
        }
        if (other.getProtocol() == null ^ this.getProtocol() == null) {
            return false;
        }
        if (other.getProtocol() != null && !other.getProtocol().equals(this.getProtocol())) {
            return false;
        }
        if (other.getRuleAction() == null ^ this.getRuleAction() == null) {
            return false;
        }
        if (other.getRuleAction() != null && !other.getRuleAction().equals(this.getRuleAction())) {
            return false;
        }
        if (other.getDirection() == null ^ this.getDirection() == null) {
            return false;
        }
        return other.getDirection() == null || other.getDirection().equals(this.getDirection());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getRuleGroupArn() == null ? 0 : this.getRuleGroupArn().hashCode());
        hashCode = 31 * hashCode + (this.getSources() == null ? 0 : this.getSources().hashCode());
        hashCode = 31 * hashCode + (this.getDestinations() == null ? 0 : this.getDestinations().hashCode());
        hashCode = 31 * hashCode + (this.getSourcePorts() == null ? 0 : this.getSourcePorts().hashCode());
        hashCode = 31 * hashCode + (this.getDestinationPorts() == null ? 0 : this.getDestinationPorts().hashCode());
        hashCode = 31 * hashCode + (this.getProtocol() == null ? 0 : this.getProtocol().hashCode());
        hashCode = 31 * hashCode + (this.getRuleAction() == null ? 0 : this.getRuleAction().hashCode());
        hashCode = 31 * hashCode + (this.getDirection() == null ? 0 : this.getDirection().hashCode());
        return hashCode;
    }

    public FirewallStatefulRule clone() {
        try {
            return (FirewallStatefulRule)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

