/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.PathStatementRequest;
import com.amazonaws.services.ec2.model.ThroughResourcesStatementRequest;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class AccessScopePathRequest
implements Serializable,
Cloneable {
    private PathStatementRequest source;
    private PathStatementRequest destination;
    private SdkInternalList<ThroughResourcesStatementRequest> throughResources;

    public void setSource(PathStatementRequest source) {
        this.source = source;
    }

    public PathStatementRequest getSource() {
        return this.source;
    }

    public AccessScopePathRequest withSource(PathStatementRequest source) {
        this.setSource(source);
        return this;
    }

    public void setDestination(PathStatementRequest destination) {
        this.destination = destination;
    }

    public PathStatementRequest getDestination() {
        return this.destination;
    }

    public AccessScopePathRequest withDestination(PathStatementRequest destination) {
        this.setDestination(destination);
        return this;
    }

    public List<ThroughResourcesStatementRequest> getThroughResources() {
        if (this.throughResources == null) {
            this.throughResources = new SdkInternalList();
        }
        return this.throughResources;
    }

    public void setThroughResources(Collection<ThroughResourcesStatementRequest> throughResources) {
        if (throughResources == null) {
            this.throughResources = null;
            return;
        }
        this.throughResources = new SdkInternalList(throughResources);
    }

    public AccessScopePathRequest withThroughResources(ThroughResourcesStatementRequest ... throughResources) {
        if (this.throughResources == null) {
            this.setThroughResources((Collection<ThroughResourcesStatementRequest>)new SdkInternalList(throughResources.length));
        }
        for (ThroughResourcesStatementRequest ele : throughResources) {
            this.throughResources.add((Object)ele);
        }
        return this;
    }

    public AccessScopePathRequest withThroughResources(Collection<ThroughResourcesStatementRequest> throughResources) {
        this.setThroughResources(throughResources);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSource() != null) {
            sb.append("Source: ").append(this.getSource()).append(",");
        }
        if (this.getDestination() != null) {
            sb.append("Destination: ").append(this.getDestination()).append(",");
        }
        if (this.getThroughResources() != null) {
            sb.append("ThroughResources: ").append(this.getThroughResources());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AccessScopePathRequest)) {
            return false;
        }
        AccessScopePathRequest other = (AccessScopePathRequest)obj;
        if (other.getSource() == null ^ this.getSource() == null) {
            return false;
        }
        if (other.getSource() != null && !other.getSource().equals(this.getSource())) {
            return false;
        }
        if (other.getDestination() == null ^ this.getDestination() == null) {
            return false;
        }
        if (other.getDestination() != null && !other.getDestination().equals(this.getDestination())) {
            return false;
        }
        if (other.getThroughResources() == null ^ this.getThroughResources() == null) {
            return false;
        }
        return other.getThroughResources() == null || other.getThroughResources().equals(this.getThroughResources());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSource() == null ? 0 : this.getSource().hashCode());
        hashCode = 31 * hashCode + (this.getDestination() == null ? 0 : this.getDestination().hashCode());
        hashCode = 31 * hashCode + (this.getThroughResources() == null ? 0 : this.getThroughResources().hashCode());
        return hashCode;
    }

    public AccessScopePathRequest clone() {
        try {
            return (AccessScopePathRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

