/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateVpcRequest;
import com.amazonaws.services.ec2.model.Tag;
import com.amazonaws.services.ec2.model.TagSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateVpcRequestMarshaller
implements Marshaller<Request<CreateVpcRequest>, CreateVpcRequest> {
    public Request<CreateVpcRequest> marshall(CreateVpcRequest createVpcRequest) {
        SdkInternalList createVpcRequestTagSpecificationsList;
        if (createVpcRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createVpcRequest, "AmazonEC2");
        request.addParameter("Action", "CreateVpc");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createVpcRequest.getAmazonProvidedIpv6CidrBlock() != null) {
            request.addParameter("AmazonProvidedIpv6CidrBlock", StringUtils.fromBoolean((Boolean)createVpcRequest.getAmazonProvidedIpv6CidrBlock()));
        }
        if (createVpcRequest.getIpv6Pool() != null) {
            request.addParameter("Ipv6Pool", StringUtils.fromString((String)createVpcRequest.getIpv6Pool()));
        }
        if (createVpcRequest.getIpv6CidrBlock() != null) {
            request.addParameter("Ipv6CidrBlock", StringUtils.fromString((String)createVpcRequest.getIpv6CidrBlock()));
        }
        if (createVpcRequest.getInstanceTenancy() != null) {
            request.addParameter("InstanceTenancy", StringUtils.fromString((String)createVpcRequest.getInstanceTenancy()));
        }
        if (createVpcRequest.getIpv6CidrBlockNetworkBorderGroup() != null) {
            request.addParameter("Ipv6CidrBlockNetworkBorderGroup", StringUtils.fromString((String)createVpcRequest.getIpv6CidrBlockNetworkBorderGroup()));
        }
        if (!(createVpcRequestTagSpecificationsList = (SdkInternalList)createVpcRequest.getTagSpecifications()).isEmpty() || !createVpcRequestTagSpecificationsList.isAutoConstruct()) {
            int tagSpecificationsListIndex = 1;
            for (TagSpecification createVpcRequestTagSpecificationsListValue : createVpcRequestTagSpecificationsList) {
                SdkInternalList tagSpecificationTagsList;
                if (createVpcRequestTagSpecificationsListValue.getResourceType() != null) {
                    request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".ResourceType", StringUtils.fromString((String)createVpcRequestTagSpecificationsListValue.getResourceType()));
                }
                if (!(tagSpecificationTagsList = (SdkInternalList)createVpcRequestTagSpecificationsListValue.getTags()).isEmpty() || !tagSpecificationTagsList.isAutoConstruct()) {
                    int tagsListIndex = 1;
                    for (Tag tagSpecificationTagsListValue : tagSpecificationTagsList) {
                        if (tagSpecificationTagsListValue.getKey() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Key", StringUtils.fromString((String)tagSpecificationTagsListValue.getKey()));
                        }
                        if (tagSpecificationTagsListValue.getValue() != null) {
                            request.addParameter("TagSpecification." + tagSpecificationsListIndex + ".Tag." + tagsListIndex + ".Value", StringUtils.fromString((String)tagSpecificationTagsListValue.getValue()));
                        }
                        ++tagsListIndex;
                    }
                }
                ++tagSpecificationsListIndex;
            }
        }
        if (createVpcRequest.getCidrBlock() != null) {
            request.addParameter("CidrBlock", StringUtils.fromString((String)createVpcRequest.getCidrBlock()));
        }
        return request;
    }
}

