/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeNetworkAclsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeNetworkAclsRequestMarshaller
implements Marshaller<Request<DescribeNetworkAclsRequest>, DescribeNetworkAclsRequest> {
    public Request<DescribeNetworkAclsRequest> marshall(DescribeNetworkAclsRequest describeNetworkAclsRequest) {
        SdkInternalList describeNetworkAclsRequestNetworkAclIdsList;
        if (describeNetworkAclsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeNetworkAclsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeNetworkAcls");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeNetworkAclsRequestFiltersList = (SdkInternalList)describeNetworkAclsRequest.getFilters();
        if (!describeNetworkAclsRequestFiltersList.isEmpty() || !describeNetworkAclsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeNetworkAclsRequestFiltersListValue : describeNetworkAclsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeNetworkAclsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeNetworkAclsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeNetworkAclsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (!(describeNetworkAclsRequestNetworkAclIdsList = (SdkInternalList)describeNetworkAclsRequest.getNetworkAclIds()).isEmpty() || !describeNetworkAclsRequestNetworkAclIdsList.isAutoConstruct()) {
            int networkAclIdsListIndex = 1;
            for (String describeNetworkAclsRequestNetworkAclIdsListValue : describeNetworkAclsRequestNetworkAclIdsList) {
                if (describeNetworkAclsRequestNetworkAclIdsListValue != null) {
                    request.addParameter("NetworkAclId." + networkAclIdsListIndex, StringUtils.fromString((String)describeNetworkAclsRequestNetworkAclIdsListValue));
                }
                ++networkAclIdsListIndex;
            }
        }
        if (describeNetworkAclsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeNetworkAclsRequest.getNextToken()));
        }
        if (describeNetworkAclsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeNetworkAclsRequest.getMaxResults()));
        }
        return request;
    }
}

