/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.services.ec2.model.GetIpamPoolAllocationsRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class GetIpamPoolAllocationsRequestMarshaller
implements Marshaller<Request<GetIpamPoolAllocationsRequest>, GetIpamPoolAllocationsRequest> {
    public Request<GetIpamPoolAllocationsRequest> marshall(GetIpamPoolAllocationsRequest getIpamPoolAllocationsRequest) {
        SdkInternalList getIpamPoolAllocationsRequestFiltersList;
        if (getIpamPoolAllocationsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)getIpamPoolAllocationsRequest, "AmazonEC2");
        request.addParameter("Action", "GetIpamPoolAllocations");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (getIpamPoolAllocationsRequest.getIpamPoolId() != null) {
            request.addParameter("IpamPoolId", StringUtils.fromString((String)getIpamPoolAllocationsRequest.getIpamPoolId()));
        }
        if (getIpamPoolAllocationsRequest.getIpamPoolAllocationId() != null) {
            request.addParameter("IpamPoolAllocationId", StringUtils.fromString((String)getIpamPoolAllocationsRequest.getIpamPoolAllocationId()));
        }
        if (!(getIpamPoolAllocationsRequestFiltersList = (SdkInternalList)getIpamPoolAllocationsRequest.getFilters()).isEmpty() || !getIpamPoolAllocationsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter getIpamPoolAllocationsRequestFiltersListValue : getIpamPoolAllocationsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (getIpamPoolAllocationsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)getIpamPoolAllocationsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)getIpamPoolAllocationsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (getIpamPoolAllocationsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)getIpamPoolAllocationsRequest.getMaxResults()));
        }
        if (getIpamPoolAllocationsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)getIpamPoolAllocationsRequest.getNextToken()));
        }
        return request;
    }
}

