/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeIpamsRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeIpamsRequestMarshaller
implements Marshaller<Request<DescribeIpamsRequest>, DescribeIpamsRequest> {
    public Request<DescribeIpamsRequest> marshall(DescribeIpamsRequest describeIpamsRequest) {
        SdkInternalList describeIpamsRequestIpamIdsList;
        if (describeIpamsRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeIpamsRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeIpams");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeIpamsRequestFiltersList = (SdkInternalList)describeIpamsRequest.getFilters();
        if (!describeIpamsRequestFiltersList.isEmpty() || !describeIpamsRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeIpamsRequestFiltersListValue : describeIpamsRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeIpamsRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeIpamsRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeIpamsRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeIpamsRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeIpamsRequest.getMaxResults()));
        }
        if (describeIpamsRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeIpamsRequest.getNextToken()));
        }
        if (!(describeIpamsRequestIpamIdsList = (SdkInternalList)describeIpamsRequest.getIpamIds()).isEmpty() || !describeIpamsRequestIpamIdsList.isAutoConstruct()) {
            int ipamIdsListIndex = 1;
            for (String describeIpamsRequestIpamIdsListValue : describeIpamsRequestIpamIdsList) {
                if (describeIpamsRequestIpamIdsListValue != null) {
                    request.addParameter("IpamId." + ipamIdsListIndex, StringUtils.fromString((String)describeIpamsRequestIpamIdsListValue));
                }
                ++ipamIdsListIndex;
            }
        }
        return request;
    }
}

