/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeTrafficMirrorFiltersRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeTrafficMirrorFiltersRequestMarshaller
implements Marshaller<Request<DescribeTrafficMirrorFiltersRequest>, DescribeTrafficMirrorFiltersRequest> {
    public Request<DescribeTrafficMirrorFiltersRequest> marshall(DescribeTrafficMirrorFiltersRequest describeTrafficMirrorFiltersRequest) {
        SdkInternalList describeTrafficMirrorFiltersRequestFiltersList;
        if (describeTrafficMirrorFiltersRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeTrafficMirrorFiltersRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeTrafficMirrorFilters");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsList = (SdkInternalList)describeTrafficMirrorFiltersRequest.getTrafficMirrorFilterIds();
        if (!describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsList.isEmpty() || !describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsList.isAutoConstruct()) {
            int trafficMirrorFilterIdsListIndex = 1;
            for (String describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsListValue : describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsList) {
                if (describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsListValue != null) {
                    request.addParameter("TrafficMirrorFilterId." + trafficMirrorFilterIdsListIndex, StringUtils.fromString((String)describeTrafficMirrorFiltersRequestTrafficMirrorFilterIdsListValue));
                }
                ++trafficMirrorFilterIdsListIndex;
            }
        }
        if (!(describeTrafficMirrorFiltersRequestFiltersList = (SdkInternalList)describeTrafficMirrorFiltersRequest.getFilters()).isEmpty() || !describeTrafficMirrorFiltersRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeTrafficMirrorFiltersRequestFiltersListValue : describeTrafficMirrorFiltersRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeTrafficMirrorFiltersRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeTrafficMirrorFiltersRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeTrafficMirrorFiltersRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        if (describeTrafficMirrorFiltersRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeTrafficMirrorFiltersRequest.getMaxResults()));
        }
        if (describeTrafficMirrorFiltersRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeTrafficMirrorFiltersRequest.getNextToken()));
        }
        return request;
    }
}

