/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DryRunSupportedRequest;
import com.amazonaws.services.ec2.model.transform.ReleaseAddressRequestMarshaller;
import java.io.Serializable;

public class ReleaseAddressRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable,
DryRunSupportedRequest<ReleaseAddressRequest> {
    private String allocationId;
    private String publicIp;
    private String networkBorderGroup;

    public ReleaseAddressRequest() {
    }

    public ReleaseAddressRequest(String publicIp) {
        this.setPublicIp(publicIp);
    }

    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public ReleaseAddressRequest withAllocationId(String allocationId) {
        this.setAllocationId(allocationId);
        return this;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public ReleaseAddressRequest withPublicIp(String publicIp) {
        this.setPublicIp(publicIp);
        return this;
    }

    public void setNetworkBorderGroup(String networkBorderGroup) {
        this.networkBorderGroup = networkBorderGroup;
    }

    public String getNetworkBorderGroup() {
        return this.networkBorderGroup;
    }

    public ReleaseAddressRequest withNetworkBorderGroup(String networkBorderGroup) {
        this.setNetworkBorderGroup(networkBorderGroup);
        return this;
    }

    @Override
    public Request<ReleaseAddressRequest> getDryRunRequest() {
        Request<ReleaseAddressRequest> request = new ReleaseAddressRequestMarshaller().marshall(this);
        request.addParameter("DryRun", Boolean.toString(true));
        return request;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationId() != null) {
            sb.append("AllocationId: ").append(this.getAllocationId()).append(",");
        }
        if (this.getPublicIp() != null) {
            sb.append("PublicIp: ").append(this.getPublicIp()).append(",");
        }
        if (this.getNetworkBorderGroup() != null) {
            sb.append("NetworkBorderGroup: ").append(this.getNetworkBorderGroup());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ReleaseAddressRequest)) {
            return false;
        }
        ReleaseAddressRequest other = (ReleaseAddressRequest)obj;
        if (other.getAllocationId() == null ^ this.getAllocationId() == null) {
            return false;
        }
        if (other.getAllocationId() != null && !other.getAllocationId().equals(this.getAllocationId())) {
            return false;
        }
        if (other.getPublicIp() == null ^ this.getPublicIp() == null) {
            return false;
        }
        if (other.getPublicIp() != null && !other.getPublicIp().equals(this.getPublicIp())) {
            return false;
        }
        if (other.getNetworkBorderGroup() == null ^ this.getNetworkBorderGroup() == null) {
            return false;
        }
        return other.getNetworkBorderGroup() == null || other.getNetworkBorderGroup().equals(this.getNetworkBorderGroup());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationId() == null ? 0 : this.getAllocationId().hashCode());
        hashCode = 31 * hashCode + (this.getPublicIp() == null ? 0 : this.getPublicIp().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkBorderGroup() == null ? 0 : this.getNetworkBorderGroup().hashCode());
        return hashCode;
    }

    public ReleaseAddressRequest clone() {
        return (ReleaseAddressRequest)super.clone();
    }
}

