/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ModifyLaunchTemplateRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ModifyLaunchTemplateRequestMarshaller
implements Marshaller<Request<ModifyLaunchTemplateRequest>, ModifyLaunchTemplateRequest> {
    public Request<ModifyLaunchTemplateRequest> marshall(ModifyLaunchTemplateRequest modifyLaunchTemplateRequest) {
        if (modifyLaunchTemplateRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)modifyLaunchTemplateRequest, "AmazonEC2");
        request.addParameter("Action", "ModifyLaunchTemplate");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (modifyLaunchTemplateRequest.getClientToken() != null) {
            request.addParameter("ClientToken", StringUtils.fromString((String)modifyLaunchTemplateRequest.getClientToken()));
        }
        if (modifyLaunchTemplateRequest.getLaunchTemplateId() != null) {
            request.addParameter("LaunchTemplateId", StringUtils.fromString((String)modifyLaunchTemplateRequest.getLaunchTemplateId()));
        }
        if (modifyLaunchTemplateRequest.getLaunchTemplateName() != null) {
            request.addParameter("LaunchTemplateName", StringUtils.fromString((String)modifyLaunchTemplateRequest.getLaunchTemplateName()));
        }
        if (modifyLaunchTemplateRequest.getDefaultVersion() != null) {
            request.addParameter("SetDefaultVersion", StringUtils.fromString((String)modifyLaunchTemplateRequest.getDefaultVersion()));
        }
        return request;
    }
}

