/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.DescribeFleetInstancesRequest;
import com.amazonaws.services.ec2.model.Filter;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class DescribeFleetInstancesRequestMarshaller
implements Marshaller<Request<DescribeFleetInstancesRequest>, DescribeFleetInstancesRequest> {
    public Request<DescribeFleetInstancesRequest> marshall(DescribeFleetInstancesRequest describeFleetInstancesRequest) {
        SdkInternalList describeFleetInstancesRequestFiltersList;
        if (describeFleetInstancesRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)describeFleetInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "DescribeFleetInstances");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (describeFleetInstancesRequest.getMaxResults() != null) {
            request.addParameter("MaxResults", StringUtils.fromInteger((Integer)describeFleetInstancesRequest.getMaxResults()));
        }
        if (describeFleetInstancesRequest.getNextToken() != null) {
            request.addParameter("NextToken", StringUtils.fromString((String)describeFleetInstancesRequest.getNextToken()));
        }
        if (describeFleetInstancesRequest.getFleetId() != null) {
            request.addParameter("FleetId", StringUtils.fromString((String)describeFleetInstancesRequest.getFleetId()));
        }
        if (!(describeFleetInstancesRequestFiltersList = (SdkInternalList)describeFleetInstancesRequest.getFilters()).isEmpty() || !describeFleetInstancesRequestFiltersList.isAutoConstruct()) {
            int filtersListIndex = 1;
            for (Filter describeFleetInstancesRequestFiltersListValue : describeFleetInstancesRequestFiltersList) {
                SdkInternalList filterValuesList;
                if (describeFleetInstancesRequestFiltersListValue.getName() != null) {
                    request.addParameter("Filter." + filtersListIndex + ".Name", StringUtils.fromString((String)describeFleetInstancesRequestFiltersListValue.getName()));
                }
                if (!(filterValuesList = (SdkInternalList)describeFleetInstancesRequestFiltersListValue.getValues()).isEmpty() || !filterValuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String filterValuesListValue : filterValuesList) {
                        if (filterValuesListValue != null) {
                            request.addParameter("Filter." + filtersListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)filterValuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++filtersListIndex;
            }
        }
        return request;
    }
}

