/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CidrAuthorizationContext;
import com.amazonaws.services.ec2.model.ProvisionByoipCidrRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ProvisionByoipCidrRequestMarshaller
implements Marshaller<Request<ProvisionByoipCidrRequest>, ProvisionByoipCidrRequest> {
    public Request<ProvisionByoipCidrRequest> marshall(ProvisionByoipCidrRequest provisionByoipCidrRequest) {
        CidrAuthorizationContext cidrAuthorizationContext;
        if (provisionByoipCidrRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)provisionByoipCidrRequest, "AmazonEC2");
        request.addParameter("Action", "ProvisionByoipCidr");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (provisionByoipCidrRequest.getCidr() != null) {
            request.addParameter("Cidr", StringUtils.fromString((String)provisionByoipCidrRequest.getCidr()));
        }
        if ((cidrAuthorizationContext = provisionByoipCidrRequest.getCidrAuthorizationContext()) != null) {
            if (cidrAuthorizationContext.getMessage() != null) {
                request.addParameter("CidrAuthorizationContext.Message", StringUtils.fromString((String)cidrAuthorizationContext.getMessage()));
            }
            if (cidrAuthorizationContext.getSignature() != null) {
                request.addParameter("CidrAuthorizationContext.Signature", StringUtils.fromString((String)cidrAuthorizationContext.getSignature()));
            }
        }
        if (provisionByoipCidrRequest.getPubliclyAdvertisable() != null) {
            request.addParameter("PubliclyAdvertisable", StringUtils.fromBoolean((Boolean)provisionByoipCidrRequest.getPubliclyAdvertisable()));
        }
        if (provisionByoipCidrRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)provisionByoipCidrRequest.getDescription()));
        }
        return request;
    }
}

