/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.SdkClientException;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.AuthorizeClientVpnIngressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeClientVpnIngressRequestMarshaller
implements Marshaller<Request<AuthorizeClientVpnIngressRequest>, AuthorizeClientVpnIngressRequest> {
    public Request<AuthorizeClientVpnIngressRequest> marshall(AuthorizeClientVpnIngressRequest authorizeClientVpnIngressRequest) {
        if (authorizeClientVpnIngressRequest == null) {
            throw new SdkClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeClientVpnIngressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeClientVpnIngress");
        request.addParameter("Version", "2016-11-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeClientVpnIngressRequest.getClientVpnEndpointId() != null) {
            request.addParameter("ClientVpnEndpointId", StringUtils.fromString((String)authorizeClientVpnIngressRequest.getClientVpnEndpointId()));
        }
        if (authorizeClientVpnIngressRequest.getTargetNetworkCidr() != null) {
            request.addParameter("TargetNetworkCidr", StringUtils.fromString((String)authorizeClientVpnIngressRequest.getTargetNetworkCidr()));
        }
        if (authorizeClientVpnIngressRequest.getAccessGroupId() != null) {
            request.addParameter("AccessGroupId", StringUtils.fromString((String)authorizeClientVpnIngressRequest.getAccessGroupId()));
        }
        if (authorizeClientVpnIngressRequest.getAuthorizeAllGroups() != null) {
            request.addParameter("AuthorizeAllGroups", StringUtils.fromBoolean((Boolean)authorizeClientVpnIngressRequest.getAuthorizeAllGroups()));
        }
        if (authorizeClientVpnIngressRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)authorizeClientVpnIngressRequest.getDescription()));
        }
        return request;
    }
}

