/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.services.ec2.model.SpotAllocationStrategy;
import com.amazonaws.services.ec2.model.SpotInstanceInterruptionBehavior;
import java.io.Serializable;

public class SpotOptionsRequest
implements Serializable,
Cloneable {
    private String allocationStrategy;
    private String instanceInterruptionBehavior;
    private Integer instancePoolsToUseCount;
    private Boolean singleInstanceType;
    private Boolean singleAvailabilityZone;
    private Integer minTargetCapacity;

    public void setAllocationStrategy(String allocationStrategy) {
        this.allocationStrategy = allocationStrategy;
    }

    public String getAllocationStrategy() {
        return this.allocationStrategy;
    }

    public SpotOptionsRequest withAllocationStrategy(String allocationStrategy) {
        this.setAllocationStrategy(allocationStrategy);
        return this;
    }

    public SpotOptionsRequest withAllocationStrategy(SpotAllocationStrategy allocationStrategy) {
        this.allocationStrategy = allocationStrategy.toString();
        return this;
    }

    public void setInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior;
    }

    public String getInstanceInterruptionBehavior() {
        return this.instanceInterruptionBehavior;
    }

    public SpotOptionsRequest withInstanceInterruptionBehavior(String instanceInterruptionBehavior) {
        this.setInstanceInterruptionBehavior(instanceInterruptionBehavior);
        return this;
    }

    public SpotOptionsRequest withInstanceInterruptionBehavior(SpotInstanceInterruptionBehavior instanceInterruptionBehavior) {
        this.instanceInterruptionBehavior = instanceInterruptionBehavior.toString();
        return this;
    }

    public void setInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.instancePoolsToUseCount = instancePoolsToUseCount;
    }

    public Integer getInstancePoolsToUseCount() {
        return this.instancePoolsToUseCount;
    }

    public SpotOptionsRequest withInstancePoolsToUseCount(Integer instancePoolsToUseCount) {
        this.setInstancePoolsToUseCount(instancePoolsToUseCount);
        return this;
    }

    public void setSingleInstanceType(Boolean singleInstanceType) {
        this.singleInstanceType = singleInstanceType;
    }

    public Boolean getSingleInstanceType() {
        return this.singleInstanceType;
    }

    public SpotOptionsRequest withSingleInstanceType(Boolean singleInstanceType) {
        this.setSingleInstanceType(singleInstanceType);
        return this;
    }

    public Boolean isSingleInstanceType() {
        return this.singleInstanceType;
    }

    public void setSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.singleAvailabilityZone = singleAvailabilityZone;
    }

    public Boolean getSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public SpotOptionsRequest withSingleAvailabilityZone(Boolean singleAvailabilityZone) {
        this.setSingleAvailabilityZone(singleAvailabilityZone);
        return this;
    }

    public Boolean isSingleAvailabilityZone() {
        return this.singleAvailabilityZone;
    }

    public void setMinTargetCapacity(Integer minTargetCapacity) {
        this.minTargetCapacity = minTargetCapacity;
    }

    public Integer getMinTargetCapacity() {
        return this.minTargetCapacity;
    }

    public SpotOptionsRequest withMinTargetCapacity(Integer minTargetCapacity) {
        this.setMinTargetCapacity(minTargetCapacity);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getAllocationStrategy() != null) {
            sb.append("AllocationStrategy: ").append(this.getAllocationStrategy()).append(",");
        }
        if (this.getInstanceInterruptionBehavior() != null) {
            sb.append("InstanceInterruptionBehavior: ").append(this.getInstanceInterruptionBehavior()).append(",");
        }
        if (this.getInstancePoolsToUseCount() != null) {
            sb.append("InstancePoolsToUseCount: ").append(this.getInstancePoolsToUseCount()).append(",");
        }
        if (this.getSingleInstanceType() != null) {
            sb.append("SingleInstanceType: ").append(this.getSingleInstanceType()).append(",");
        }
        if (this.getSingleAvailabilityZone() != null) {
            sb.append("SingleAvailabilityZone: ").append(this.getSingleAvailabilityZone()).append(",");
        }
        if (this.getMinTargetCapacity() != null) {
            sb.append("MinTargetCapacity: ").append(this.getMinTargetCapacity());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotOptionsRequest)) {
            return false;
        }
        SpotOptionsRequest other = (SpotOptionsRequest)obj;
        if (other.getAllocationStrategy() == null ^ this.getAllocationStrategy() == null) {
            return false;
        }
        if (other.getAllocationStrategy() != null && !other.getAllocationStrategy().equals(this.getAllocationStrategy())) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() == null ^ this.getInstanceInterruptionBehavior() == null) {
            return false;
        }
        if (other.getInstanceInterruptionBehavior() != null && !other.getInstanceInterruptionBehavior().equals(this.getInstanceInterruptionBehavior())) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() == null ^ this.getInstancePoolsToUseCount() == null) {
            return false;
        }
        if (other.getInstancePoolsToUseCount() != null && !other.getInstancePoolsToUseCount().equals(this.getInstancePoolsToUseCount())) {
            return false;
        }
        if (other.getSingleInstanceType() == null ^ this.getSingleInstanceType() == null) {
            return false;
        }
        if (other.getSingleInstanceType() != null && !other.getSingleInstanceType().equals(this.getSingleInstanceType())) {
            return false;
        }
        if (other.getSingleAvailabilityZone() == null ^ this.getSingleAvailabilityZone() == null) {
            return false;
        }
        if (other.getSingleAvailabilityZone() != null && !other.getSingleAvailabilityZone().equals(this.getSingleAvailabilityZone())) {
            return false;
        }
        if (other.getMinTargetCapacity() == null ^ this.getMinTargetCapacity() == null) {
            return false;
        }
        return other.getMinTargetCapacity() == null || other.getMinTargetCapacity().equals(this.getMinTargetCapacity());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getAllocationStrategy() == null ? 0 : this.getAllocationStrategy().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceInterruptionBehavior() == null ? 0 : this.getInstanceInterruptionBehavior().hashCode());
        hashCode = 31 * hashCode + (this.getInstancePoolsToUseCount() == null ? 0 : this.getInstancePoolsToUseCount().hashCode());
        hashCode = 31 * hashCode + (this.getSingleInstanceType() == null ? 0 : this.getSingleInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getSingleAvailabilityZone() == null ? 0 : this.getSingleAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getMinTargetCapacity() == null ? 0 : this.getMinTargetCapacity().hashCode());
        return hashCode;
    }

    public SpotOptionsRequest clone() {
        try {
            return (SpotOptionsRequest)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

