/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.RebootInstancesRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class RebootInstancesRequestMarshaller
implements Marshaller<Request<RebootInstancesRequest>, RebootInstancesRequest> {
    public Request<RebootInstancesRequest> marshall(RebootInstancesRequest rebootInstancesRequest) {
        if (rebootInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)rebootInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RebootInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList rebootInstancesRequestInstanceIdsList = (SdkInternalList)rebootInstancesRequest.getInstanceIds();
        if (!rebootInstancesRequestInstanceIdsList.isEmpty() || !rebootInstancesRequestInstanceIdsList.isAutoConstruct()) {
            int instanceIdsListIndex = 1;
            for (String rebootInstancesRequestInstanceIdsListValue : rebootInstancesRequestInstanceIdsList) {
                if (rebootInstancesRequestInstanceIdsListValue != null) {
                    request.addParameter("InstanceId." + instanceIdsListIndex, StringUtils.fromString((String)rebootInstancesRequestInstanceIdsListValue));
                }
                ++instanceIdsListIndex;
            }
        }
        return request;
    }
}

