/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateNetworkInterfaceRequest;
import com.amazonaws.services.ec2.model.PrivateIpAddressSpecification;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateNetworkInterfaceRequestMarshaller
implements Marshaller<Request<CreateNetworkInterfaceRequest>, CreateNetworkInterfaceRequest> {
    public Request<CreateNetworkInterfaceRequest> marshall(CreateNetworkInterfaceRequest createNetworkInterfaceRequest) {
        SdkInternalList createNetworkInterfaceRequestPrivateIpAddressesList;
        SdkInternalList createNetworkInterfaceRequestGroupsList;
        if (createNetworkInterfaceRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createNetworkInterfaceRequest, "AmazonEC2");
        request.addParameter("Action", "CreateNetworkInterface");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        if (createNetworkInterfaceRequest.getSubnetId() != null) {
            request.addParameter("SubnetId", StringUtils.fromString((String)createNetworkInterfaceRequest.getSubnetId()));
        }
        if (createNetworkInterfaceRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)createNetworkInterfaceRequest.getDescription()));
        }
        if (createNetworkInterfaceRequest.getPrivateIpAddress() != null) {
            request.addParameter("PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequest.getPrivateIpAddress()));
        }
        if (!(createNetworkInterfaceRequestGroupsList = (SdkInternalList)createNetworkInterfaceRequest.getGroups()).isEmpty() || !createNetworkInterfaceRequestGroupsList.isAutoConstruct()) {
            int groupsListIndex = 1;
            for (String createNetworkInterfaceRequestGroupsListValue : createNetworkInterfaceRequestGroupsList) {
                if (createNetworkInterfaceRequestGroupsListValue != null) {
                    request.addParameter("SecurityGroupId." + groupsListIndex, StringUtils.fromString((String)createNetworkInterfaceRequestGroupsListValue));
                }
                ++groupsListIndex;
            }
        }
        if (!(createNetworkInterfaceRequestPrivateIpAddressesList = (SdkInternalList)createNetworkInterfaceRequest.getPrivateIpAddresses()).isEmpty() || !createNetworkInterfaceRequestPrivateIpAddressesList.isAutoConstruct()) {
            int privateIpAddressesListIndex = 1;
            for (PrivateIpAddressSpecification createNetworkInterfaceRequestPrivateIpAddressesListValue : createNetworkInterfaceRequestPrivateIpAddressesList) {
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.getPrivateIpAddress() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)createNetworkInterfaceRequestPrivateIpAddressesListValue.getPrivateIpAddress()));
                }
                if (createNetworkInterfaceRequestPrivateIpAddressesListValue.getPrimary() != null) {
                    request.addParameter("PrivateIpAddresses." + privateIpAddressesListIndex + ".Primary", StringUtils.fromBoolean((Boolean)createNetworkInterfaceRequestPrivateIpAddressesListValue.getPrimary()));
                }
                ++privateIpAddressesListIndex;
            }
        }
        if (createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount() != null) {
            request.addParameter("SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)createNetworkInterfaceRequest.getSecondaryPrivateIpAddressCount()));
        }
        return request;
    }
}

