/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.RunScheduledInstancesRequest;
import com.amazonaws.services.ec2.model.ScheduledInstancesBlockDeviceMapping;
import com.amazonaws.services.ec2.model.ScheduledInstancesEbs;
import com.amazonaws.services.ec2.model.ScheduledInstancesIamInstanceProfile;
import com.amazonaws.services.ec2.model.ScheduledInstancesLaunchSpecification;
import com.amazonaws.services.ec2.model.ScheduledInstancesMonitoring;
import com.amazonaws.services.ec2.model.ScheduledInstancesNetworkInterface;
import com.amazonaws.services.ec2.model.ScheduledInstancesPlacement;
import com.amazonaws.services.ec2.model.ScheduledInstancesPrivateIpAddressConfig;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.IdempotentUtils;
import com.amazonaws.util.StringUtils;

public class RunScheduledInstancesRequestMarshaller
implements Marshaller<Request<RunScheduledInstancesRequest>, RunScheduledInstancesRequest> {
    public Request<RunScheduledInstancesRequest> marshall(RunScheduledInstancesRequest runScheduledInstancesRequest) {
        ScheduledInstancesLaunchSpecification launchSpecification;
        if (runScheduledInstancesRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)runScheduledInstancesRequest, "AmazonEC2");
        request.addParameter("Action", "RunScheduledInstances");
        request.addParameter("Version", "2016-09-15");
        request.setHttpMethod(HttpMethodName.POST);
        request.addParameter("ClientToken", IdempotentUtils.resolveString((String)runScheduledInstancesRequest.getClientToken()));
        if (runScheduledInstancesRequest.getInstanceCount() != null) {
            request.addParameter("InstanceCount", StringUtils.fromInteger((Integer)runScheduledInstancesRequest.getInstanceCount()));
        }
        if (runScheduledInstancesRequest.getScheduledInstanceId() != null) {
            request.addParameter("ScheduledInstanceId", StringUtils.fromString((String)runScheduledInstancesRequest.getScheduledInstanceId()));
        }
        if ((launchSpecification = runScheduledInstancesRequest.getLaunchSpecification()) != null) {
            ScheduledInstancesIamInstanceProfile iamInstanceProfile;
            SdkInternalList networkInterfacesList;
            ScheduledInstancesMonitoring monitoring;
            SdkInternalList blockDeviceMappingsList;
            ScheduledInstancesPlacement placement;
            SdkInternalList securityGroupIdsList;
            if (launchSpecification.getImageId() != null) {
                request.addParameter("LaunchSpecification.ImageId", StringUtils.fromString((String)launchSpecification.getImageId()));
            }
            if (launchSpecification.getKeyName() != null) {
                request.addParameter("LaunchSpecification.KeyName", StringUtils.fromString((String)launchSpecification.getKeyName()));
            }
            if (!(securityGroupIdsList = (SdkInternalList)launchSpecification.getSecurityGroupIds()).isEmpty() || !securityGroupIdsList.isAutoConstruct()) {
                int securityGroupIdsListIndex = 1;
                for (String securityGroupIdsListValue : securityGroupIdsList) {
                    if (securityGroupIdsListValue != null) {
                        request.addParameter("LaunchSpecification.SecurityGroupId." + securityGroupIdsListIndex, StringUtils.fromString((String)securityGroupIdsListValue));
                    }
                    ++securityGroupIdsListIndex;
                }
            }
            if (launchSpecification.getUserData() != null) {
                request.addParameter("LaunchSpecification.UserData", StringUtils.fromString((String)launchSpecification.getUserData()));
            }
            if ((placement = launchSpecification.getPlacement()) != null) {
                if (placement.getAvailabilityZone() != null) {
                    request.addParameter("LaunchSpecification.Placement.AvailabilityZone", StringUtils.fromString((String)placement.getAvailabilityZone()));
                }
                if (placement.getGroupName() != null) {
                    request.addParameter("LaunchSpecification.Placement.GroupName", StringUtils.fromString((String)placement.getGroupName()));
                }
            }
            if (launchSpecification.getKernelId() != null) {
                request.addParameter("LaunchSpecification.KernelId", StringUtils.fromString((String)launchSpecification.getKernelId()));
            }
            if (launchSpecification.getInstanceType() != null) {
                request.addParameter("LaunchSpecification.InstanceType", StringUtils.fromString((String)launchSpecification.getInstanceType()));
            }
            if (launchSpecification.getRamdiskId() != null) {
                request.addParameter("LaunchSpecification.RamdiskId", StringUtils.fromString((String)launchSpecification.getRamdiskId()));
            }
            if (!(blockDeviceMappingsList = (SdkInternalList)launchSpecification.getBlockDeviceMappings()).isEmpty() || !blockDeviceMappingsList.isAutoConstruct()) {
                int blockDeviceMappingsListIndex = 1;
                for (ScheduledInstancesBlockDeviceMapping blockDeviceMappingsListValue : blockDeviceMappingsList) {
                    ScheduledInstancesEbs ebs;
                    if (blockDeviceMappingsListValue.getDeviceName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".DeviceName", StringUtils.fromString((String)blockDeviceMappingsListValue.getDeviceName()));
                    }
                    if (blockDeviceMappingsListValue.getNoDevice() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".NoDevice", StringUtils.fromString((String)blockDeviceMappingsListValue.getNoDevice()));
                    }
                    if (blockDeviceMappingsListValue.getVirtualName() != null) {
                        request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".VirtualName", StringUtils.fromString((String)blockDeviceMappingsListValue.getVirtualName()));
                    }
                    if ((ebs = blockDeviceMappingsListValue.getEbs()) != null) {
                        if (ebs.getSnapshotId() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.SnapshotId", StringUtils.fromString((String)ebs.getSnapshotId()));
                        }
                        if (ebs.getVolumeSize() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeSize", StringUtils.fromInteger((Integer)ebs.getVolumeSize()));
                        }
                        if (ebs.getDeleteOnTermination() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.DeleteOnTermination", StringUtils.fromBoolean((Boolean)ebs.getDeleteOnTermination()));
                        }
                        if (ebs.getVolumeType() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.VolumeType", StringUtils.fromString((String)ebs.getVolumeType()));
                        }
                        if (ebs.getIops() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Iops", StringUtils.fromInteger((Integer)ebs.getIops()));
                        }
                        if (ebs.getEncrypted() != null) {
                            request.addParameter("LaunchSpecification.BlockDeviceMapping." + blockDeviceMappingsListIndex + ".Ebs.Encrypted", StringUtils.fromBoolean((Boolean)ebs.getEncrypted()));
                        }
                    }
                    ++blockDeviceMappingsListIndex;
                }
            }
            if ((monitoring = launchSpecification.getMonitoring()) != null && monitoring.getEnabled() != null) {
                request.addParameter("LaunchSpecification.Monitoring.Enabled", StringUtils.fromBoolean((Boolean)monitoring.getEnabled()));
            }
            if (launchSpecification.getSubnetId() != null) {
                request.addParameter("LaunchSpecification.SubnetId", StringUtils.fromString((String)launchSpecification.getSubnetId()));
            }
            if (!(networkInterfacesList = (SdkInternalList)launchSpecification.getNetworkInterfaces()).isEmpty() || !networkInterfacesList.isAutoConstruct()) {
                int networkInterfacesListIndex = 1;
                for (ScheduledInstancesNetworkInterface networkInterfacesListValue : networkInterfacesList) {
                    SdkInternalList groupsList;
                    SdkInternalList privateIpAddressConfigsList;
                    if (networkInterfacesListValue.getNetworkInterfaceId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".NetworkInterfaceId", StringUtils.fromString((String)networkInterfacesListValue.getNetworkInterfaceId()));
                    }
                    if (networkInterfacesListValue.getDeviceIndex() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeviceIndex", StringUtils.fromInteger((Integer)networkInterfacesListValue.getDeviceIndex()));
                    }
                    if (networkInterfacesListValue.getSubnetId() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SubnetId", StringUtils.fromString((String)networkInterfacesListValue.getSubnetId()));
                    }
                    if (networkInterfacesListValue.getDescription() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Description", StringUtils.fromString((String)networkInterfacesListValue.getDescription()));
                    }
                    if (networkInterfacesListValue.getPrivateIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddress", StringUtils.fromString((String)networkInterfacesListValue.getPrivateIpAddress()));
                    }
                    if (!(privateIpAddressConfigsList = (SdkInternalList)networkInterfacesListValue.getPrivateIpAddressConfigs()).isEmpty() || !privateIpAddressConfigsList.isAutoConstruct()) {
                        int privateIpAddressConfigsListIndex = 1;
                        for (ScheduledInstancesPrivateIpAddressConfig privateIpAddressConfigsListValue : privateIpAddressConfigsList) {
                            if (privateIpAddressConfigsListValue.getPrivateIpAddress() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".PrivateIpAddress", StringUtils.fromString((String)privateIpAddressConfigsListValue.getPrivateIpAddress()));
                            }
                            if (privateIpAddressConfigsListValue.getPrimary() != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".PrivateIpAddressConfig." + privateIpAddressConfigsListIndex + ".Primary", StringUtils.fromBoolean((Boolean)privateIpAddressConfigsListValue.getPrimary()));
                            }
                            ++privateIpAddressConfigsListIndex;
                        }
                    }
                    if (networkInterfacesListValue.getSecondaryPrivateIpAddressCount() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".SecondaryPrivateIpAddressCount", StringUtils.fromInteger((Integer)networkInterfacesListValue.getSecondaryPrivateIpAddressCount()));
                    }
                    if (networkInterfacesListValue.getAssociatePublicIpAddress() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".AssociatePublicIpAddress", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getAssociatePublicIpAddress()));
                    }
                    if (!(groupsList = (SdkInternalList)networkInterfacesListValue.getGroups()).isEmpty() || !groupsList.isAutoConstruct()) {
                        int groupsListIndex = 1;
                        for (String groupsListValue : groupsList) {
                            if (groupsListValue != null) {
                                request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".Group." + groupsListIndex, StringUtils.fromString((String)groupsListValue));
                            }
                            ++groupsListIndex;
                        }
                    }
                    if (networkInterfacesListValue.getDeleteOnTermination() != null) {
                        request.addParameter("LaunchSpecification.NetworkInterface." + networkInterfacesListIndex + ".DeleteOnTermination", StringUtils.fromBoolean((Boolean)networkInterfacesListValue.getDeleteOnTermination()));
                    }
                    ++networkInterfacesListIndex;
                }
            }
            if ((iamInstanceProfile = launchSpecification.getIamInstanceProfile()) != null) {
                if (iamInstanceProfile.getArn() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Arn", StringUtils.fromString((String)iamInstanceProfile.getArn()));
                }
                if (iamInstanceProfile.getName() != null) {
                    request.addParameter("LaunchSpecification.IamInstanceProfile.Name", StringUtils.fromString((String)iamInstanceProfile.getName()));
                }
            }
            if (launchSpecification.getEbsOptimized() != null) {
                request.addParameter("LaunchSpecification.EbsOptimized", StringUtils.fromBoolean((Boolean)launchSpecification.getEbsOptimized()));
            }
        }
        return request;
    }
}

