/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.CreateKeyPairRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateKeyPairRequestMarshaller
implements Marshaller<Request<CreateKeyPairRequest>, CreateKeyPairRequest> {
    public Request<CreateKeyPairRequest> marshall(CreateKeyPairRequest createKeyPairRequest) {
        if (createKeyPairRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createKeyPairRequest, "AmazonEC2");
        request.addParameter("Action", "CreateKeyPair");
        request.addParameter("Version", "2016-04-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (createKeyPairRequest.getKeyName() != null) {
            request.addParameter("KeyName", StringUtils.fromString((String)createKeyPairRequest.getKeyName()));
        }
        return request;
    }
}

