/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.services.ec2.model.VpcEndpoint;
import com.amazonaws.transform.SimpleTypeStaxUnmarshallers;
import com.amazonaws.transform.StaxUnmarshallerContext;
import com.amazonaws.transform.Unmarshaller;
import java.util.ArrayList;
import javax.xml.stream.events.XMLEvent;

public class VpcEndpointStaxUnmarshaller
implements Unmarshaller<VpcEndpoint, StaxUnmarshallerContext> {
    private static VpcEndpointStaxUnmarshaller instance;

    public VpcEndpoint unmarshall(StaxUnmarshallerContext context) throws Exception {
        VpcEndpoint vpcEndpoint = new VpcEndpoint();
        int originalDepth = context.getCurrentDepth();
        int targetDepth = originalDepth + 1;
        if (context.isStartOfDocument()) {
            ++targetDepth;
        }
        while (true) {
            XMLEvent xmlEvent;
            if ((xmlEvent = context.nextEvent()).isEndDocument()) {
                return vpcEndpoint;
            }
            if (xmlEvent.isAttribute() || xmlEvent.isStartElement()) {
                if (context.testExpression("creationTimestamp", targetDepth)) {
                    vpcEndpoint.setCreationTimestamp(SimpleTypeStaxUnmarshallers.DateStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("policyDocument", targetDepth)) {
                    vpcEndpoint.setPolicyDocument(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("routeTableIdSet", targetDepth)) {
                    vpcEndpoint.withRouteTableIds(new ArrayList<String>());
                    continue;
                }
                if (context.testExpression("routeTableIdSet/item", targetDepth)) {
                    vpcEndpoint.withRouteTableIds(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("serviceName", targetDepth)) {
                    vpcEndpoint.setServiceName(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("state", targetDepth)) {
                    vpcEndpoint.setState(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (context.testExpression("vpcEndpointId", targetDepth)) {
                    vpcEndpoint.setVpcEndpointId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                    continue;
                }
                if (!context.testExpression("vpcId", targetDepth)) continue;
                vpcEndpoint.setVpcId(SimpleTypeStaxUnmarshallers.StringStaxUnmarshaller.getInstance().unmarshall(context));
                continue;
            }
            if (xmlEvent.isEndElement() && context.getCurrentDepth() < originalDepth) break;
        }
        return vpcEndpoint;
    }

    public static VpcEndpointStaxUnmarshaller getInstance() {
        if (instance == null) {
            instance = new VpcEndpointStaxUnmarshaller();
        }
        return instance;
    }
}

