/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.ImportInstanceVolumeDetailItem;
import com.amazonaws.services.ec2.model.PlatformValues;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;

public class ImportInstanceTaskDetails
implements Serializable,
Cloneable {
    private String description;
    private String instanceId;
    private String platform;
    private SdkInternalList<ImportInstanceVolumeDetailItem> volumes;

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public ImportInstanceTaskDetails withDescription(String description) {
        this.setDescription(description);
        return this;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public ImportInstanceTaskDetails withInstanceId(String instanceId) {
        this.setInstanceId(instanceId);
        return this;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public String getPlatform() {
        return this.platform;
    }

    public ImportInstanceTaskDetails withPlatform(String platform) {
        this.setPlatform(platform);
        return this;
    }

    public void setPlatform(PlatformValues platform) {
        this.platform = platform.toString();
    }

    public ImportInstanceTaskDetails withPlatform(PlatformValues platform) {
        this.setPlatform(platform);
        return this;
    }

    public List<ImportInstanceVolumeDetailItem> getVolumes() {
        if (this.volumes == null) {
            this.volumes = new SdkInternalList();
        }
        return this.volumes;
    }

    public void setVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
        if (volumes == null) {
            this.volumes = null;
            return;
        }
        this.volumes = new SdkInternalList(volumes);
    }

    public ImportInstanceTaskDetails withVolumes(ImportInstanceVolumeDetailItem ... volumes) {
        if (this.volumes == null) {
            this.setVolumes((Collection<ImportInstanceVolumeDetailItem>)new SdkInternalList(volumes.length));
        }
        for (ImportInstanceVolumeDetailItem ele : volumes) {
            this.volumes.add((Object)ele);
        }
        return this;
    }

    public ImportInstanceTaskDetails withVolumes(Collection<ImportInstanceVolumeDetailItem> volumes) {
        this.setVolumes(volumes);
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getDescription() != null) {
            sb.append("Description: ").append(this.getDescription()).append(",");
        }
        if (this.getInstanceId() != null) {
            sb.append("InstanceId: ").append(this.getInstanceId()).append(",");
        }
        if (this.getPlatform() != null) {
            sb.append("Platform: ").append(this.getPlatform()).append(",");
        }
        if (this.getVolumes() != null) {
            sb.append("Volumes: ").append(this.getVolumes());
        }
        sb.append("}");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ImportInstanceTaskDetails)) {
            return false;
        }
        ImportInstanceTaskDetails other = (ImportInstanceTaskDetails)obj;
        if (other.getDescription() == null ^ this.getDescription() == null) {
            return false;
        }
        if (other.getDescription() != null && !other.getDescription().equals(this.getDescription())) {
            return false;
        }
        if (other.getInstanceId() == null ^ this.getInstanceId() == null) {
            return false;
        }
        if (other.getInstanceId() != null && !other.getInstanceId().equals(this.getInstanceId())) {
            return false;
        }
        if (other.getPlatform() == null ^ this.getPlatform() == null) {
            return false;
        }
        if (other.getPlatform() != null && !other.getPlatform().equals(this.getPlatform())) {
            return false;
        }
        if (other.getVolumes() == null ^ this.getVolumes() == null) {
            return false;
        }
        return other.getVolumes() == null || other.getVolumes().equals(this.getVolumes());
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDescription() == null ? 0 : this.getDescription().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceId() == null ? 0 : this.getInstanceId().hashCode());
        hashCode = 31 * hashCode + (this.getPlatform() == null ? 0 : this.getPlatform().hashCode());
        hashCode = 31 * hashCode + (this.getVolumes() == null ? 0 : this.getVolumes().hashCode());
        return hashCode;
    }

    public ImportInstanceTaskDetails clone() {
        try {
            return (ImportInstanceTaskDetails)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

