/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.AuthorizeSecurityGroupIngressRequest;
import com.amazonaws.services.ec2.model.IpPermission;
import com.amazonaws.services.ec2.model.PrefixListId;
import com.amazonaws.services.ec2.model.UserIdGroupPair;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class AuthorizeSecurityGroupIngressRequestMarshaller
implements Marshaller<Request<AuthorizeSecurityGroupIngressRequest>, AuthorizeSecurityGroupIngressRequest> {
    public Request<AuthorizeSecurityGroupIngressRequest> marshall(AuthorizeSecurityGroupIngressRequest authorizeSecurityGroupIngressRequest) {
        SdkInternalList ipPermissionsList;
        if (authorizeSecurityGroupIngressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)authorizeSecurityGroupIngressRequest, "AmazonEC2");
        request.addParameter("Action", "AuthorizeSecurityGroupIngress");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (authorizeSecurityGroupIngressRequest.getGroupName() != null) {
            request.addParameter("GroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getGroupName()));
        }
        if (authorizeSecurityGroupIngressRequest.getGroupId() != null) {
            request.addParameter("GroupId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getGroupId()));
        }
        if (authorizeSecurityGroupIngressRequest.getSourceSecurityGroupName() != null) {
            request.addParameter("SourceSecurityGroupName", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getSourceSecurityGroupName()));
        }
        if (authorizeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId() != null) {
            request.addParameter("SourceSecurityGroupOwnerId", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getSourceSecurityGroupOwnerId()));
        }
        if (authorizeSecurityGroupIngressRequest.getIpProtocol() != null) {
            request.addParameter("IpProtocol", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getIpProtocol()));
        }
        if (authorizeSecurityGroupIngressRequest.getFromPort() != null) {
            request.addParameter("FromPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.getFromPort()));
        }
        if (authorizeSecurityGroupIngressRequest.getToPort() != null) {
            request.addParameter("ToPort", StringUtils.fromInteger((Integer)authorizeSecurityGroupIngressRequest.getToPort()));
        }
        if (authorizeSecurityGroupIngressRequest.getCidrIp() != null) {
            request.addParameter("CidrIp", StringUtils.fromString((String)authorizeSecurityGroupIngressRequest.getCidrIp()));
        }
        if (!(ipPermissionsList = (SdkInternalList)authorizeSecurityGroupIngressRequest.getIpPermissions()).isEmpty() || !ipPermissionsList.isAutoConstruct()) {
            int ipPermissionsListIndex = 1;
            for (IpPermission ipPermissionsListValue : ipPermissionsList) {
                SdkInternalList prefixListIdsList;
                SdkInternalList ipRangesList;
                SdkInternalList userIdGroupPairsList;
                if (ipPermissionsListValue.getIpProtocol() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpProtocol", StringUtils.fromString((String)ipPermissionsListValue.getIpProtocol()));
                }
                if (ipPermissionsListValue.getFromPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".FromPort", StringUtils.fromInteger((Integer)ipPermissionsListValue.getFromPort()));
                }
                if (ipPermissionsListValue.getToPort() != null) {
                    request.addParameter("IpPermissions." + ipPermissionsListIndex + ".ToPort", StringUtils.fromInteger((Integer)ipPermissionsListValue.getToPort()));
                }
                if (!(userIdGroupPairsList = (SdkInternalList)ipPermissionsListValue.getUserIdGroupPairs()).isEmpty() || !userIdGroupPairsList.isAutoConstruct()) {
                    int userIdGroupPairsListIndex = 1;
                    for (Object userIdGroupPairsListValue : userIdGroupPairsList) {
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getUserId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".UserId", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getUserId()));
                        }
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getGroupName() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupName", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getGroupName()));
                        }
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getGroupId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".GroupId", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getGroupId()));
                        }
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getVpcId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcId", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getVpcId()));
                        }
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getVpcPeeringConnectionId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".VpcPeeringConnectionId", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getVpcPeeringConnectionId()));
                        }
                        if (((UserIdGroupPair)userIdGroupPairsListValue).getPeeringStatus() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".Groups." + userIdGroupPairsListIndex + ".PeeringStatus", StringUtils.fromString((String)((UserIdGroupPair)userIdGroupPairsListValue).getPeeringStatus()));
                        }
                        ++userIdGroupPairsListIndex;
                    }
                }
                if (!(ipRangesList = (SdkInternalList)ipPermissionsListValue.getIpRanges()).isEmpty() || !ipRangesList.isAutoConstruct()) {
                    Object userIdGroupPairsListValue;
                    int ipRangesListIndex = 1;
                    userIdGroupPairsListValue = ipRangesList.iterator();
                    while (userIdGroupPairsListValue.hasNext()) {
                        String ipRangesListValue = (String)userIdGroupPairsListValue.next();
                        if (ipRangesListValue != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".IpRanges." + ipRangesListIndex + ".CidrIp", StringUtils.fromString((String)ipRangesListValue));
                        }
                        ++ipRangesListIndex;
                    }
                }
                if (!(prefixListIdsList = (SdkInternalList)ipPermissionsListValue.getPrefixListIds()).isEmpty() || !prefixListIdsList.isAutoConstruct()) {
                    int prefixListIdsListIndex = 1;
                    for (PrefixListId prefixListIdsListValue : prefixListIdsList) {
                        if (prefixListIdsListValue.getPrefixListId() != null) {
                            request.addParameter("IpPermissions." + ipPermissionsListIndex + ".PrefixListIds." + prefixListIdsListIndex + ".PrefixListId", StringUtils.fromString((String)prefixListIdsListValue.getPrefixListId()));
                        }
                        ++prefixListIdsListIndex;
                    }
                }
                ++ipPermissionsListIndex;
            }
        }
        return request;
    }
}

