/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.internal.SdkInternalList;
import com.amazonaws.services.ec2.model.CreateDhcpOptionsRequest;
import com.amazonaws.services.ec2.model.DhcpConfiguration;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class CreateDhcpOptionsRequestMarshaller
implements Marshaller<Request<CreateDhcpOptionsRequest>, CreateDhcpOptionsRequest> {
    public Request<CreateDhcpOptionsRequest> marshall(CreateDhcpOptionsRequest createDhcpOptionsRequest) {
        if (createDhcpOptionsRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)createDhcpOptionsRequest, "AmazonEC2");
        request.addParameter("Action", "CreateDhcpOptions");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        SdkInternalList dhcpConfigurationsList = (SdkInternalList)createDhcpOptionsRequest.getDhcpConfigurations();
        if (!dhcpConfigurationsList.isEmpty() || !dhcpConfigurationsList.isAutoConstruct()) {
            int dhcpConfigurationsListIndex = 1;
            for (DhcpConfiguration dhcpConfigurationsListValue : dhcpConfigurationsList) {
                SdkInternalList valuesList;
                if (dhcpConfigurationsListValue.getKey() != null) {
                    request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Key", StringUtils.fromString((String)dhcpConfigurationsListValue.getKey()));
                }
                if (!(valuesList = (SdkInternalList)dhcpConfigurationsListValue.getValues()).isEmpty() || !valuesList.isAutoConstruct()) {
                    int valuesListIndex = 1;
                    for (String valuesListValue : valuesList) {
                        if (valuesListValue != null) {
                            request.addParameter("DhcpConfiguration." + dhcpConfigurationsListIndex + ".Value." + valuesListIndex, StringUtils.fromString((String)valuesListValue));
                        }
                        ++valuesListIndex;
                    }
                }
                ++dhcpConfigurationsListIndex;
            }
        }
        return request;
    }
}

