/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.http.HttpMethodName;
import com.amazonaws.services.ec2.model.ReleaseAddressRequest;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ReleaseAddressRequestMarshaller
implements Marshaller<Request<ReleaseAddressRequest>, ReleaseAddressRequest> {
    public Request<ReleaseAddressRequest> marshall(ReleaseAddressRequest releaseAddressRequest) {
        if (releaseAddressRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)releaseAddressRequest, "AmazonEC2");
        request.addParameter("Action", "ReleaseAddress");
        request.addParameter("Version", "2015-10-01");
        request.setHttpMethod(HttpMethodName.POST);
        if (releaseAddressRequest.getPublicIp() != null) {
            request.addParameter("PublicIp", StringUtils.fromString((String)releaseAddressRequest.getPublicIp()));
        }
        if (releaseAddressRequest.getAllocationId() != null) {
            request.addParameter("AllocationId", StringUtils.fromString((String)releaseAddressRequest.getAllocationId()));
        }
        return request;
    }
}

