/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.SecurityGroup;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class DescribeSecurityGroupsResult
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<SecurityGroup> securityGroups;

    public List<SecurityGroup> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ListWithAutoConstructFlag();
            this.securityGroups.setAutoConstruct(true);
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<SecurityGroup> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public DescribeSecurityGroupsResult withSecurityGroups(SecurityGroup ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<SecurityGroup>(securityGroups.length));
        }
        for (SecurityGroup value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public DescribeSecurityGroupsResult withSecurityGroups(Collection<SecurityGroup> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeSecurityGroupsResult)) {
            return false;
        }
        DescribeSecurityGroupsResult other = (DescribeSecurityGroupsResult)obj;
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        return other.getSecurityGroups() == null || other.getSecurityGroups().equals(this.getSecurityGroups());
    }

    public DescribeSecurityGroupsResult clone() {
        try {
            return (DescribeSecurityGroupsResult)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

