/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.AutoPlacement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class ModifyHostsRequest
extends AmazonWebServiceRequest
implements Serializable,
Cloneable {
    private ListWithAutoConstructFlag<String> hostIds;
    private String autoPlacement;

    public List<String> getHostIds() {
        if (this.hostIds == null) {
            this.hostIds = new ListWithAutoConstructFlag();
            this.hostIds.setAutoConstruct(true);
        }
        return this.hostIds;
    }

    public void setHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
            return;
        }
        ListWithAutoConstructFlag hostIdsCopy = new ListWithAutoConstructFlag(hostIds.size());
        hostIdsCopy.addAll(hostIds);
        this.hostIds = hostIdsCopy;
    }

    public ModifyHostsRequest withHostIds(String ... hostIds) {
        if (this.getHostIds() == null) {
            this.setHostIds(new ArrayList<String>(hostIds.length));
        }
        for (String value : hostIds) {
            this.getHostIds().add(value);
        }
        return this;
    }

    public ModifyHostsRequest withHostIds(Collection<String> hostIds) {
        if (hostIds == null) {
            this.hostIds = null;
        } else {
            ListWithAutoConstructFlag hostIdsCopy = new ListWithAutoConstructFlag(hostIds.size());
            hostIdsCopy.addAll(hostIds);
            this.hostIds = hostIdsCopy;
        }
        return this;
    }

    public String getAutoPlacement() {
        return this.autoPlacement;
    }

    public void setAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
    }

    public ModifyHostsRequest withAutoPlacement(String autoPlacement) {
        this.autoPlacement = autoPlacement;
        return this;
    }

    public void setAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
    }

    public ModifyHostsRequest withAutoPlacement(AutoPlacement autoPlacement) {
        this.autoPlacement = autoPlacement.toString();
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getHostIds() != null) {
            sb.append("HostIds: " + this.getHostIds() + ",");
        }
        if (this.getAutoPlacement() != null) {
            sb.append("AutoPlacement: " + this.getAutoPlacement());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getHostIds() == null ? 0 : this.getHostIds().hashCode());
        hashCode = 31 * hashCode + (this.getAutoPlacement() == null ? 0 : this.getAutoPlacement().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ModifyHostsRequest)) {
            return false;
        }
        ModifyHostsRequest other = (ModifyHostsRequest)obj;
        if (other.getHostIds() == null ^ this.getHostIds() == null) {
            return false;
        }
        if (other.getHostIds() != null && !other.getHostIds().equals(this.getHostIds())) {
            return false;
        }
        if (other.getAutoPlacement() == null ^ this.getAutoPlacement() == null) {
            return false;
        }
        return other.getAutoPlacement() == null || other.getAutoPlacement().equals(this.getAutoPlacement());
    }

    public ModifyHostsRequest clone() {
        return (ModifyHostsRequest)super.clone();
    }
}

