/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model.transform;

import com.amazonaws.AmazonClientException;
import com.amazonaws.AmazonWebServiceRequest;
import com.amazonaws.DefaultRequest;
import com.amazonaws.Request;
import com.amazonaws.services.ec2.model.DiskImageDetail;
import com.amazonaws.services.ec2.model.ImportVolumeRequest;
import com.amazonaws.services.ec2.model.VolumeDetail;
import com.amazonaws.transform.Marshaller;
import com.amazonaws.util.StringUtils;

public class ImportVolumeRequestMarshaller
implements Marshaller<Request<ImportVolumeRequest>, ImportVolumeRequest> {
    public Request<ImportVolumeRequest> marshall(ImportVolumeRequest importVolumeRequest) {
        VolumeDetail volumeDetailVolume;
        DiskImageDetail diskImageDetailImage;
        if (importVolumeRequest == null) {
            throw new AmazonClientException("Invalid argument passed to marshall(...)");
        }
        DefaultRequest request = new DefaultRequest((AmazonWebServiceRequest)importVolumeRequest, "AmazonEC2");
        request.addParameter("Action", "ImportVolume");
        request.addParameter("Version", "2015-10-01");
        if (importVolumeRequest.getAvailabilityZone() != null) {
            request.addParameter("AvailabilityZone", StringUtils.fromString((String)importVolumeRequest.getAvailabilityZone()));
        }
        if ((diskImageDetailImage = importVolumeRequest.getImage()) != null) {
            if (diskImageDetailImage.getFormat() != null) {
                request.addParameter("Image.Format", StringUtils.fromString((String)diskImageDetailImage.getFormat()));
            }
            if (diskImageDetailImage.getBytes() != null) {
                request.addParameter("Image.Bytes", StringUtils.fromLong((Long)diskImageDetailImage.getBytes()));
            }
            if (diskImageDetailImage.getImportManifestUrl() != null) {
                request.addParameter("Image.ImportManifestUrl", StringUtils.fromString((String)diskImageDetailImage.getImportManifestUrl()));
            }
        }
        if (importVolumeRequest.getDescription() != null) {
            request.addParameter("Description", StringUtils.fromString((String)importVolumeRequest.getDescription()));
        }
        if ((volumeDetailVolume = importVolumeRequest.getVolume()) != null && volumeDetailVolume.getSize() != null) {
            request.addParameter("Volume.Size", StringUtils.fromLong((Long)volumeDetailVolume.getSize()));
        }
        return request;
    }
}

