/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.ec2.model;

import com.amazonaws.internal.ListWithAutoConstructFlag;
import com.amazonaws.services.ec2.model.BlockDeviceMapping;
import com.amazonaws.services.ec2.model.GroupIdentifier;
import com.amazonaws.services.ec2.model.IamInstanceProfileSpecification;
import com.amazonaws.services.ec2.model.InstanceNetworkInterfaceSpecification;
import com.amazonaws.services.ec2.model.InstanceType;
import com.amazonaws.services.ec2.model.SpotFleetMonitoring;
import com.amazonaws.services.ec2.model.SpotPlacement;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SpotFleetLaunchSpecification
implements Serializable,
Cloneable {
    private String imageId;
    private String keyName;
    private ListWithAutoConstructFlag<GroupIdentifier> securityGroups;
    private String userData;
    private String addressingType;
    private String instanceType;
    private SpotPlacement placement;
    private String kernelId;
    private String ramdiskId;
    private ListWithAutoConstructFlag<BlockDeviceMapping> blockDeviceMappings;
    private SpotFleetMonitoring monitoring;
    private String subnetId;
    private ListWithAutoConstructFlag<InstanceNetworkInterfaceSpecification> networkInterfaces;
    private IamInstanceProfileSpecification iamInstanceProfile;
    private Boolean ebsOptimized;

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public SpotFleetLaunchSpecification withImageId(String imageId) {
        this.imageId = imageId;
        return this;
    }

    public String getKeyName() {
        return this.keyName;
    }

    public void setKeyName(String keyName) {
        this.keyName = keyName;
    }

    public SpotFleetLaunchSpecification withKeyName(String keyName) {
        this.keyName = keyName;
        return this;
    }

    public List<GroupIdentifier> getSecurityGroups() {
        if (this.securityGroups == null) {
            this.securityGroups = new ListWithAutoConstructFlag();
            this.securityGroups.setAutoConstruct(true);
        }
        return this.securityGroups;
    }

    public void setSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
            return;
        }
        ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
        securityGroupsCopy.addAll(securityGroups);
        this.securityGroups = securityGroupsCopy;
    }

    public SpotFleetLaunchSpecification withSecurityGroups(GroupIdentifier ... securityGroups) {
        if (this.getSecurityGroups() == null) {
            this.setSecurityGroups(new ArrayList<GroupIdentifier>(securityGroups.length));
        }
        for (GroupIdentifier value : securityGroups) {
            this.getSecurityGroups().add(value);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withSecurityGroups(Collection<GroupIdentifier> securityGroups) {
        if (securityGroups == null) {
            this.securityGroups = null;
        } else {
            ListWithAutoConstructFlag securityGroupsCopy = new ListWithAutoConstructFlag(securityGroups.size());
            securityGroupsCopy.addAll(securityGroups);
            this.securityGroups = securityGroupsCopy;
        }
        return this;
    }

    public String getUserData() {
        return this.userData;
    }

    public void setUserData(String userData) {
        this.userData = userData;
    }

    public SpotFleetLaunchSpecification withUserData(String userData) {
        this.userData = userData;
        return this;
    }

    public String getAddressingType() {
        return this.addressingType;
    }

    public void setAddressingType(String addressingType) {
        this.addressingType = addressingType;
    }

    public SpotFleetLaunchSpecification withAddressingType(String addressingType) {
        this.addressingType = addressingType;
        return this;
    }

    public String getInstanceType() {
        return this.instanceType;
    }

    public void setInstanceType(String instanceType) {
        this.instanceType = instanceType;
    }

    public SpotFleetLaunchSpecification withInstanceType(String instanceType) {
        this.instanceType = instanceType;
        return this;
    }

    public void setInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
    }

    public SpotFleetLaunchSpecification withInstanceType(InstanceType instanceType) {
        this.instanceType = instanceType.toString();
        return this;
    }

    public SpotPlacement getPlacement() {
        return this.placement;
    }

    public void setPlacement(SpotPlacement placement) {
        this.placement = placement;
    }

    public SpotFleetLaunchSpecification withPlacement(SpotPlacement placement) {
        this.placement = placement;
        return this;
    }

    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    public SpotFleetLaunchSpecification withKernelId(String kernelId) {
        this.kernelId = kernelId;
        return this;
    }

    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    public SpotFleetLaunchSpecification withRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
        return this;
    }

    public List<BlockDeviceMapping> getBlockDeviceMappings() {
        if (this.blockDeviceMappings == null) {
            this.blockDeviceMappings = new ListWithAutoConstructFlag();
            this.blockDeviceMappings.setAutoConstruct(true);
        }
        return this.blockDeviceMappings;
    }

    public void setBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
            return;
        }
        ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
        blockDeviceMappingsCopy.addAll(blockDeviceMappings);
        this.blockDeviceMappings = blockDeviceMappingsCopy;
    }

    public SpotFleetLaunchSpecification withBlockDeviceMappings(BlockDeviceMapping ... blockDeviceMappings) {
        if (this.getBlockDeviceMappings() == null) {
            this.setBlockDeviceMappings(new ArrayList<BlockDeviceMapping>(blockDeviceMappings.length));
        }
        for (BlockDeviceMapping value : blockDeviceMappings) {
            this.getBlockDeviceMappings().add(value);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withBlockDeviceMappings(Collection<BlockDeviceMapping> blockDeviceMappings) {
        if (blockDeviceMappings == null) {
            this.blockDeviceMappings = null;
        } else {
            ListWithAutoConstructFlag blockDeviceMappingsCopy = new ListWithAutoConstructFlag(blockDeviceMappings.size());
            blockDeviceMappingsCopy.addAll(blockDeviceMappings);
            this.blockDeviceMappings = blockDeviceMappingsCopy;
        }
        return this;
    }

    public SpotFleetMonitoring getMonitoring() {
        return this.monitoring;
    }

    public void setMonitoring(SpotFleetMonitoring monitoring) {
        this.monitoring = monitoring;
    }

    public SpotFleetLaunchSpecification withMonitoring(SpotFleetMonitoring monitoring) {
        this.monitoring = monitoring;
        return this;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }

    public SpotFleetLaunchSpecification withSubnetId(String subnetId) {
        this.subnetId = subnetId;
        return this;
    }

    public List<InstanceNetworkInterfaceSpecification> getNetworkInterfaces() {
        if (this.networkInterfaces == null) {
            this.networkInterfaces = new ListWithAutoConstructFlag();
            this.networkInterfaces.setAutoConstruct(true);
        }
        return this.networkInterfaces;
    }

    public void setNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
            return;
        }
        ListWithAutoConstructFlag networkInterfacesCopy = new ListWithAutoConstructFlag(networkInterfaces.size());
        networkInterfacesCopy.addAll(networkInterfaces);
        this.networkInterfaces = networkInterfacesCopy;
    }

    public SpotFleetLaunchSpecification withNetworkInterfaces(InstanceNetworkInterfaceSpecification ... networkInterfaces) {
        if (this.getNetworkInterfaces() == null) {
            this.setNetworkInterfaces(new ArrayList<InstanceNetworkInterfaceSpecification>(networkInterfaces.length));
        }
        for (InstanceNetworkInterfaceSpecification value : networkInterfaces) {
            this.getNetworkInterfaces().add(value);
        }
        return this;
    }

    public SpotFleetLaunchSpecification withNetworkInterfaces(Collection<InstanceNetworkInterfaceSpecification> networkInterfaces) {
        if (networkInterfaces == null) {
            this.networkInterfaces = null;
        } else {
            ListWithAutoConstructFlag networkInterfacesCopy = new ListWithAutoConstructFlag(networkInterfaces.size());
            networkInterfacesCopy.addAll(networkInterfaces);
            this.networkInterfaces = networkInterfacesCopy;
        }
        return this;
    }

    public IamInstanceProfileSpecification getIamInstanceProfile() {
        return this.iamInstanceProfile;
    }

    public void setIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
    }

    public SpotFleetLaunchSpecification withIamInstanceProfile(IamInstanceProfileSpecification iamInstanceProfile) {
        this.iamInstanceProfile = iamInstanceProfile;
        return this;
    }

    public Boolean isEbsOptimized() {
        return this.ebsOptimized;
    }

    public void setEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
    }

    public SpotFleetLaunchSpecification withEbsOptimized(Boolean ebsOptimized) {
        this.ebsOptimized = ebsOptimized;
        return this;
    }

    public Boolean getEbsOptimized() {
        return this.ebsOptimized;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.getImageId() != null) {
            sb.append("ImageId: " + this.getImageId() + ",");
        }
        if (this.getKeyName() != null) {
            sb.append("KeyName: " + this.getKeyName() + ",");
        }
        if (this.getSecurityGroups() != null) {
            sb.append("SecurityGroups: " + this.getSecurityGroups() + ",");
        }
        if (this.getUserData() != null) {
            sb.append("UserData: " + this.getUserData() + ",");
        }
        if (this.getAddressingType() != null) {
            sb.append("AddressingType: " + this.getAddressingType() + ",");
        }
        if (this.getInstanceType() != null) {
            sb.append("InstanceType: " + this.getInstanceType() + ",");
        }
        if (this.getPlacement() != null) {
            sb.append("Placement: " + this.getPlacement() + ",");
        }
        if (this.getKernelId() != null) {
            sb.append("KernelId: " + this.getKernelId() + ",");
        }
        if (this.getRamdiskId() != null) {
            sb.append("RamdiskId: " + this.getRamdiskId() + ",");
        }
        if (this.getBlockDeviceMappings() != null) {
            sb.append("BlockDeviceMappings: " + this.getBlockDeviceMappings() + ",");
        }
        if (this.getMonitoring() != null) {
            sb.append("Monitoring: " + this.getMonitoring() + ",");
        }
        if (this.getSubnetId() != null) {
            sb.append("SubnetId: " + this.getSubnetId() + ",");
        }
        if (this.getNetworkInterfaces() != null) {
            sb.append("NetworkInterfaces: " + this.getNetworkInterfaces() + ",");
        }
        if (this.getIamInstanceProfile() != null) {
            sb.append("IamInstanceProfile: " + this.getIamInstanceProfile() + ",");
        }
        if (this.isEbsOptimized() != null) {
            sb.append("EbsOptimized: " + this.isEbsOptimized());
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getImageId() == null ? 0 : this.getImageId().hashCode());
        hashCode = 31 * hashCode + (this.getKeyName() == null ? 0 : this.getKeyName().hashCode());
        hashCode = 31 * hashCode + (this.getSecurityGroups() == null ? 0 : this.getSecurityGroups().hashCode());
        hashCode = 31 * hashCode + (this.getUserData() == null ? 0 : this.getUserData().hashCode());
        hashCode = 31 * hashCode + (this.getAddressingType() == null ? 0 : this.getAddressingType().hashCode());
        hashCode = 31 * hashCode + (this.getInstanceType() == null ? 0 : this.getInstanceType().hashCode());
        hashCode = 31 * hashCode + (this.getPlacement() == null ? 0 : this.getPlacement().hashCode());
        hashCode = 31 * hashCode + (this.getKernelId() == null ? 0 : this.getKernelId().hashCode());
        hashCode = 31 * hashCode + (this.getRamdiskId() == null ? 0 : this.getRamdiskId().hashCode());
        hashCode = 31 * hashCode + (this.getBlockDeviceMappings() == null ? 0 : this.getBlockDeviceMappings().hashCode());
        hashCode = 31 * hashCode + (this.getMonitoring() == null ? 0 : this.getMonitoring().hashCode());
        hashCode = 31 * hashCode + (this.getSubnetId() == null ? 0 : this.getSubnetId().hashCode());
        hashCode = 31 * hashCode + (this.getNetworkInterfaces() == null ? 0 : this.getNetworkInterfaces().hashCode());
        hashCode = 31 * hashCode + (this.getIamInstanceProfile() == null ? 0 : this.getIamInstanceProfile().hashCode());
        hashCode = 31 * hashCode + (this.isEbsOptimized() == null ? 0 : this.isEbsOptimized().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SpotFleetLaunchSpecification)) {
            return false;
        }
        SpotFleetLaunchSpecification other = (SpotFleetLaunchSpecification)obj;
        if (other.getImageId() == null ^ this.getImageId() == null) {
            return false;
        }
        if (other.getImageId() != null && !other.getImageId().equals(this.getImageId())) {
            return false;
        }
        if (other.getKeyName() == null ^ this.getKeyName() == null) {
            return false;
        }
        if (other.getKeyName() != null && !other.getKeyName().equals(this.getKeyName())) {
            return false;
        }
        if (other.getSecurityGroups() == null ^ this.getSecurityGroups() == null) {
            return false;
        }
        if (other.getSecurityGroups() != null && !other.getSecurityGroups().equals(this.getSecurityGroups())) {
            return false;
        }
        if (other.getUserData() == null ^ this.getUserData() == null) {
            return false;
        }
        if (other.getUserData() != null && !other.getUserData().equals(this.getUserData())) {
            return false;
        }
        if (other.getAddressingType() == null ^ this.getAddressingType() == null) {
            return false;
        }
        if (other.getAddressingType() != null && !other.getAddressingType().equals(this.getAddressingType())) {
            return false;
        }
        if (other.getInstanceType() == null ^ this.getInstanceType() == null) {
            return false;
        }
        if (other.getInstanceType() != null && !other.getInstanceType().equals(this.getInstanceType())) {
            return false;
        }
        if (other.getPlacement() == null ^ this.getPlacement() == null) {
            return false;
        }
        if (other.getPlacement() != null && !other.getPlacement().equals(this.getPlacement())) {
            return false;
        }
        if (other.getKernelId() == null ^ this.getKernelId() == null) {
            return false;
        }
        if (other.getKernelId() != null && !other.getKernelId().equals(this.getKernelId())) {
            return false;
        }
        if (other.getRamdiskId() == null ^ this.getRamdiskId() == null) {
            return false;
        }
        if (other.getRamdiskId() != null && !other.getRamdiskId().equals(this.getRamdiskId())) {
            return false;
        }
        if (other.getBlockDeviceMappings() == null ^ this.getBlockDeviceMappings() == null) {
            return false;
        }
        if (other.getBlockDeviceMappings() != null && !other.getBlockDeviceMappings().equals(this.getBlockDeviceMappings())) {
            return false;
        }
        if (other.getMonitoring() == null ^ this.getMonitoring() == null) {
            return false;
        }
        if (other.getMonitoring() != null && !other.getMonitoring().equals(this.getMonitoring())) {
            return false;
        }
        if (other.getSubnetId() == null ^ this.getSubnetId() == null) {
            return false;
        }
        if (other.getSubnetId() != null && !other.getSubnetId().equals(this.getSubnetId())) {
            return false;
        }
        if (other.getNetworkInterfaces() == null ^ this.getNetworkInterfaces() == null) {
            return false;
        }
        if (other.getNetworkInterfaces() != null && !other.getNetworkInterfaces().equals(this.getNetworkInterfaces())) {
            return false;
        }
        if (other.getIamInstanceProfile() == null ^ this.getIamInstanceProfile() == null) {
            return false;
        }
        if (other.getIamInstanceProfile() != null && !other.getIamInstanceProfile().equals(this.getIamInstanceProfile())) {
            return false;
        }
        if (other.isEbsOptimized() == null ^ this.isEbsOptimized() == null) {
            return false;
        }
        return other.isEbsOptimized() == null || other.isEbsOptimized().equals(this.isEbsOptimized());
    }

    public SpotFleetLaunchSpecification clone() {
        try {
            return (SpotFleetLaunchSpecification)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalStateException("Got a CloneNotSupportedException from Object.clone() even though we're Cloneable!", e);
        }
    }
}

